/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.commands;

import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.api.Recapitulatif;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueDef;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueDetails;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueItem;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueParameters;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueRecap;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueSubset;
import fr.exemole.bdfext.scarabe.api.analytique.OperationDef;
import fr.exemole.bdfext.scarabe.commands.AnalytiqueRecapCommand;
import fr.exemole.bdfext.scarabe.tools.ScarabeUtils;
import fr.exemole.bdfext.scarabe.tools.analytique.AnalytiqueParametersBuilder;
import fr.exemole.bdfext.scarabe.tools.analytique.ConversionEngineParameters;
import fr.exemole.bdfext.scarabe.tools.analytique.EngineParameters;
import fr.exemole.bdfext.scarabe.tools.analytique.NaturalEngineParameters;
import fr.exemole.bdfext.scarabe.tools.analytique.detail.DetailEngine;
import fr.exemole.bdfext.scarabe.tools.analytique.recap.RecapEngine;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import java.util.List;
import java.util.function.Predicate;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.date.DateFilterUtils;
import net.mapeadores.util.date.RangeDateFilter;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.request.RequestMap;

public class AnalytiqueDetailCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "AnalytiqueDetail";
    public static final String DATE_PARAMNAME = "date";
    public static final String ID_PARAMNAME = "id";
    public static final String IDALPHA_PARAMNAME = "idalpha";
    public static final String SELECTION_PARAMNAME = "selection";
    public static final String CONVERSION_PARAMNAME = "conversion";
    public static final String INCLUDE_PARAMNAME = "include";
    public static final String EXCLUDE_PARAMNAME = "exclude";
    public static final String INCLUDE_IDALPHA_PARAMNAME = "include_idalpha";
    public static final String EXCLUDE_IDALPHA_PARAMNAME = "exclude_idalpha";
    public static final String ROWFILTER_PARAMNAME = "filter";
    public static final String TOTAUX_ROWFILTER_PARAMVALUE = "totaux";
    public static final String WITHRECAP_PARAMNAME = "withrecap";
    private final ScarabeContext scarabeContext;
    private RangeDateFilter rangeDateFilter;
    private final Recapitulatif recapitulatif;
    private AnalytiqueItem analytiqueItem;
    private AnalytiqueParameters analytiqueParameters;
    private Predicate<FicheMeta> ligneFichePredicate;
    private EngineParameters engineParameters;

    public AnalytiqueDetailCommand(BdfServer bdfServer, RequestMap requestMap, ScarabeContext scarabeContext) {
        super(bdfServer, requestMap);
        this.scarabeContext = scarabeContext;
        this.recapitulatif = scarabeContext.getScarabeCache().getRecapitulatif(bdfServer);
    }

    public boolean needSynchronisation() {
        return false;
    }

    protected void doCommand() throws ErrorMessageException {
        DetailEngine detailEngine = DetailEngine.newDetailEngine(this.engineParameters, this.analytiqueParameters, this.rangeDateFilter, this.ligneFichePredicate);
        AnalytiqueDetails analytiqueDetails = this.analytiqueItem == null ? detailEngine.buildFromRoot() : detailEngine.buildFromAnalytiqueItem(this.analytiqueItem);
        this.putResultObject("scarabe.obj_analytiquedetails", analytiqueDetails);
        if (this.analytiqueParameters.isDetailWithRecap()) {
            AnalytiqueDef analytiqueDef = this.analytiqueParameters.getAnalytiqueSubset().getAnalytiqueDef();
            List<OperationDef> operationDefList = analytiqueDef.getOperationDefList();
            OperationDef[] operationDefArray = operationDefList.toArray(new OperationDef[operationDefList.size()]);
            RecapEngine recapEngine = RecapEngine.newRecapEngine(this.engineParameters, this.analytiqueParameters, this.rangeDateFilter, this.ligneFichePredicate, operationDefArray);
            AnalytiqueRecap analytiqueRecap = this.analytiqueItem == null ? recapEngine.buildFromRoot() : recapEngine.buildFromAnalytiqueItem(this.analytiqueItem);
            this.putResultObject("scarabe.obj_analytiquerecap", analytiqueRecap);
        }
    }

    protected void checkParameters() throws ErrorMessageException {
        String conversionString;
        String dateString;
        ScarabeUtils.checkInitState(this.scarabeContext);
        Subset subset = this.requestHandler.getMandatorySubset();
        SubsetKey subsetKey = subset.getSubsetKey();
        AnalytiqueSubset analytiqueSubset = this.recapitulatif.getAnalytiqueSubset(subsetKey);
        if (analytiqueSubset == null) {
            throw BdfErrors.error((String)"_ error.unsupported.scarabe.noanalytiquesubset", (Object[])new Object[]{subsetKey});
        }
        if (analytiqueSubset.hasError()) {
            throw BdfErrors.error((String)"_ error.wrong.scarabe.analytiquesubset", (Object[])new Object[]{subsetKey});
        }
        AnalytiqueParametersBuilder builder = new AnalytiqueParametersBuilder(analytiqueSubset);
        String idString = this.requestHandler.getTrimedParameter(ID_PARAMNAME);
        if (!idString.isEmpty()) {
            int id;
            try {
                id = Integer.parseInt(idString);
            }
            catch (NumberFormatException nfe) {
                throw BdfErrors.wrongParameterValue((String)ID_PARAMNAME, (String)idString);
            }
            this.analytiqueItem = analytiqueSubset.getAnalytiqueItem(id);
            if (this.analytiqueItem == null) {
                throw BdfErrors.error((String)"_ error.unknown.scarabe.analytiqueid", (Object[])new Object[]{idString});
            }
        } else {
            String idalphaString = this.requestHandler.getTrimedParameter(IDALPHA_PARAMNAME);
            if (!idalphaString.isEmpty() && subsetKey.isThesaurusSubset()) {
                Motcle motcle = ((Thesaurus)analytiqueSubset.getSubset()).getMotcleByIdalpha(idalphaString);
                if (motcle != null) {
                    this.analytiqueItem = analytiqueSubset.getAnalytiqueItem(motcle.getId());
                } else {
                    throw BdfErrors.error((String)"_ error.unknown.scarabe.analytiqueid", (Object[])new Object[]{idalphaString});
                }
            }
        }
        if (!(dateString = this.requestHandler.getTrimedParameter(DATE_PARAMNAME)).isEmpty()) {
            try {
                this.rangeDateFilter = DateFilterUtils.parseDateFilter((String)dateString);
            }
            catch (ParseException pe) {
                throw BdfErrors.error((String)"_ error.wrong.date", (Object[])new Object[]{dateString});
            }
        }
        boolean withSelection = false;
        if (this.requestHandler.isTrue(SELECTION_PARAMNAME)) {
            this.ligneFichePredicate = this.bdfUser.getSelectedFiches();
            builder.setMode((short)1);
            withSelection = true;
        }
        if (!(conversionString = this.requestHandler.getTrimedParameter(CONVERSION_PARAMNAME)).isEmpty()) {
            try {
                ExtendedCurrency currency = ExtendedCurrency.parse((String)conversionString);
                this.engineParameters = new ConversionEngineParameters(this.recapitulatif.getCoursManager(), currency, this.recapitulatif.getCurrencies());
                builder.setConversionCurrency(currency);
            }
            catch (ParseException pe) {
                throw BdfErrors.wrongParameterValue((String)CONVERSION_PARAMNAME, (String)conversionString);
            }
        } else {
            this.engineParameters = new NaturalEngineParameters(this.recapitulatif.getCurrencies());
        }
        builder.setIncludeIdSet(AnalytiqueRecapCommand.parseSet(analytiqueSubset, this.requestHandler.getTrimedParameter(INCLUDE_PARAMNAME), this.requestHandler.getTrimedParameter(INCLUDE_IDALPHA_PARAMNAME)));
        builder.setExcludeIdSet(AnalytiqueRecapCommand.parseSet(analytiqueSubset, this.requestHandler.getTrimedParameter(EXCLUDE_PARAMNAME), this.requestHandler.getTrimedParameter(EXCLUDE_IDALPHA_PARAMNAME)));
        String filterString = this.requestHandler.getTrimedParameter(ROWFILTER_PARAMNAME);
        if (filterString.equals(TOTAUX_ROWFILTER_PARAMVALUE)) {
            builder.setFilter((short)1);
        }
        if (this.requestHandler.isTrue(WITHRECAP_PARAMNAME) && !withSelection) {
            builder.setDetailWithRecap(true);
        }
        this.analytiqueParameters = builder.toAnalytiqueParameters();
    }
}

