/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe;

import fr.exemole.bdfext.scarabe.ScarabeBdfInstruction;
import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.tools.ScarabeUtils;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfInstruction;
import fr.exemole.bdfserver.api.providers.BdfInstructionProvider;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.tools.instruction.BdfInstructionUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import net.mapeadores.util.exceptions.InternalResourceException;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.localisation.UserLangContext;
import net.mapeadores.util.regex.RegexList;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.servlets.ResponseHandler;
import net.mapeadores.util.servlets.handlers.SimpleResponseHandler;

public class ScarabeBdfInstructionProvider
implements BdfInstructionProvider {
    private static RegexList regexList;
    private final ScarabeContext scarabeContext;

    public ScarabeBdfInstructionProvider(ScarabeContext scarabeContext) {
        this.scarabeContext = scarabeContext;
    }

    public BdfInstruction getBdfInstruction(BdfServer bdfServer, String extensionPath, RequestMap requestMap) {
        if (this.scarabeContext.getInitState() == 1) {
            Map map = regexList.getMap(extensionPath);
            if (map == null) {
                return null;
            }
            return new ScarabeBdfInstruction(bdfServer, requestMap, map, this.scarabeContext);
        }
        return new ErrorBdfInstruction(bdfServer, ScarabeUtils.getInitL10nKey(this.scarabeContext), requestMap);
    }

    static {
        try {
            String s = IOUtils.toString((InputStream)ScarabeBdfInstructionProvider.class.getResourceAsStream("regex.txt"), (String)"UTF-8");
            regexList = RegexList.parse((String)s);
        }
        catch (IOException ioe) {
            throw new InternalResourceException((Exception)ioe);
        }
    }

    private static class ErrorBdfInstruction
    implements BdfInstruction {
        private final BdfServer bdfServer;
        private final String messageKey;
        private final RequestMap requestMap;

        private ErrorBdfInstruction(BdfServer bdfServer, String messageKey, RequestMap requestMap) {
            this.bdfServer = bdfServer;
            this.messageKey = messageKey;
            this.requestMap = requestMap;
        }

        public short getBdfUserNeed() {
            return 2;
        }

        public ResponseHandler runInstruction(BdfUser bdfUser) {
            MessageLocalisation messageLocalisation = BdfInstructionUtils.getMessageLocalisation((RequestMap)this.requestMap, (BdfServer)this.bdfServer, (UserLangContext)bdfUser);
            return SimpleResponseHandler.init((String)messageLocalisation.toString(this.messageKey));
        }
    }
}

