/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.resourcesupdate.tools.memento;

import fr.exemole.bdfext.resourcesupdate.tools.memento.Destination;
import fr.exemole.bdfext.resourcesupdate.tools.memento.Unit;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.Section;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.localisation.Lang;

public class ThesaurusToMemento {
    public static final FieldKey SECTION_FIELDKEY = FieldKey.build((short)3, (String)"section");
    private static final SubsetKey mementoThesaurusKey = SubsetKey.build((short)2, (String)"memento");
    private final Fichotheque fichotheque;
    private final Thesaurus mementoThesaurus;
    private final SortedMap<Lang, Corpus> corpusMap = new TreeMap<Lang, Corpus>();

    private ThesaurusToMemento(Fichotheque fichotheque) {
        this.fichotheque = fichotheque;
        this.mementoThesaurus = (Thesaurus)fichotheque.getSubset(mementoThesaurusKey);
        for (Corpus corpus : this.mementoThesaurus.getSatelliteCorpusList()) {
            CorpusField langField = corpus.getCorpusMetadata().getCorpusField(FieldKey.LANG);
            String langScope = langField.getLangScope();
            if (!langScope.equals("list")) continue;
            Lang lang = (Lang)langField.getLangs().get(0);
            this.corpusMap.put(lang, corpus);
        }
    }

    private List<Destination> run() {
        ArrayList<Destination> destinationList = new ArrayList<Destination>();
        for (Motcle destinationMotcle : this.mementoThesaurus.getFirstLevelList()) {
            Destination destination = new Destination(destinationMotcle);
            this.scanDestination(destination);
            destinationList.add(destination);
        }
        return destinationList;
    }

    private void scanDestination(Destination destination) {
        for (Motcle unitMotcle : destination.getMotcle().getChildList()) {
            if (unitMotcle.getLabels().isEmpty()) continue;
            Unit unit = new Unit(unitMotcle, destination, this);
            destination.addUnit(unit);
        }
    }

    public Section getSection(Lang lang, Motcle motcle) {
        Corpus corpus = (Corpus)this.corpusMap.get(lang);
        if (corpus == null) {
            return null;
        }
        FicheMeta ficheMeta = corpus.getFicheMetaById(motcle.getId());
        if (ficheMeta == null) {
            return null;
        }
        return corpus.getFicheAPI(ficheMeta, true).getSection(SECTION_FIELDKEY);
    }

    public static List<Destination> convert(Fichotheque fichotheque) {
        ThesaurusToMemento mementoEngine = new ThesaurusToMemento(fichotheque);
        return mementoEngine.run();
    }
}

