/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.nssdialogues;

import fr.exemole.bdfext.nssdialogues.NssDialogues;
import fr.exemole.bdfext.nssdialogues.pages.SaisieGabaritResolver;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.instruction.BdfInstruction;
import fr.exemole.bdfserver.api.instruction.BdfInstructionConstants;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.email.EmailBuffer;
import fr.exemole.bdfserver.email.SendEngine;
import fr.exemole.bdfserver.email.ValidAddress;
import fr.exemole.bdfserver.tools.EditionEngine;
import fr.exemole.bdfserver.tools.instruction.DefaultBdfParameters;
import fr.exemole.bdfserver.tools.users.BdfUserUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import net.fichotheque.ExistingIdException;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.CorpusEditor;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.NoMasterIdException;
import net.fichotheque.corpus.fiche.EmailItem;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.Prop;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.UserLoginException;
import net.mapeadores.util.exceptions.ImplementationException;
import net.mapeadores.util.exceptions.NestedIOException;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.html.GabaritHtmlProducer;
import net.mapeadores.util.html.HtmlProducer;
import net.mapeadores.util.instruction.InstructionResolver;
import net.mapeadores.util.io.DocStream;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.models.EmailCore;
import net.mapeadores.util.request.AppendableRequestMap;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.servlets.ResponseHandler;
import net.mapeadores.util.servlets.handlers.HtmlResponseHandler;
import net.mapeadores.util.servlets.handlers.SimpleResponseHandler;

public class NssDialoguesBdfInstruction
implements BdfInstruction,
BdfInstructionConstants {
    private static final SubsetKey corpusKey = SubsetKey.build((String)"corpus_proposition");
    private static final FieldKey courrielKey = FieldKey.build((String)"prop_courriel");
    private final Map<String, String> instructionMap;
    private final RequestMap requestMap;
    private final BdfServer bdfServer;

    public NssDialoguesBdfInstruction(BdfServer bdfServer, RequestMap requestMap, Map<String, String> instructionMap) {
        this.instructionMap = instructionMap;
        this.requestMap = requestMap;
        this.bdfServer = bdfServer;
    }

    public short getBdfUserNeed() {
        return 1;
    }

    public ResponseHandler runInstruction(BdfUser bdfUser) {
        String page = this.instructionMap.get("page");
        BdfParameters firstAdminBdfParameters = BdfUserUtils.getFirstAdminBdfParameters((BdfServer)this.bdfServer);
        if (page.equals("Formulaire")) {
            String type = this.instructionMap.get("type");
            return this.getSaisieResponseHandler(type, firstAdminBdfParameters, null);
        }
        if (page.equals("Creation")) {
            Properties properties;
            try {
                properties = this.getProperties("creation");
                if (properties == null) {
                    return this.wrap("Ressource introuvable : creation.properties");
                }
            }
            catch (IOException ioe) {
                return this.wrap("IOException : " + ioe.getMessage());
            }
            FicheMeta ficheMeta = this.createFiche(properties, firstAdminBdfParameters);
            return this.getSaisieResponseHandler("resultat", firstAdminBdfParameters, ficheMeta);
        }
        return this.wrap("Page inconnue : " + page);
    }

    private SimpleResponseHandler wrap(String text) {
        return SimpleResponseHandler.init((String)text);
    }

    private ResponseHandler getSaisieResponseHandler(String type, BdfParameters bdfParameters, FicheMeta ficheMeta) {
        try {
            Properties properties = this.getProperties(type);
            if (properties == null) {
                return this.wrap("Ressource introuvable : " + type + ".properties");
            }
            String gabaritString = this.getGabarit(type);
            if (gabaritString == null) {
                return this.wrap("Ressource introuvable : saisie-" + type + ".html");
            }
            Corpus corpus = (Corpus)this.bdfServer.getFichotheque().getSubset(corpusKey);
            SaisieGabaritResolver saisieGabaritResolver = new SaisieGabaritResolver(bdfParameters, corpus, properties, ficheMeta);
            return HtmlResponseHandler.init((HtmlProducer)new GabaritHtmlProducer(gabaritString, (InstructionResolver)saisieGabaritResolver));
        }
        catch (IOException ioe) {
            return this.wrap("IOException : " + ioe.getMessage());
        }
    }

    private String getGabarit(String type) throws IOException {
        DocStream docStream = this.getExtensionDocStream("private/saisie-" + type + ".html");
        if (docStream == null) {
            return null;
        }
        try (InputStream is = docStream.getInputStream();){
            String string = IOUtils.toString((InputStream)is, (String)"UTF-8");
            return string;
        }
    }

    private Properties getProperties(String type) throws IOException {
        DocStream docStream = this.getExtensionDocStream("private/" + type + ".properties");
        if (docStream == null) {
            return null;
        }
        Properties properties = new Properties();
        try (InputStream is = docStream.getInputStream();){
            properties.load(is);
        }
        return properties;
    }

    private String getText() {
        String string;
        block9: {
            DocStream docStream = this.getExtensionDocStream("private/texte-courriel.txt");
            if (docStream == null) {
                return "";
            }
            InputStream is = docStream.getInputStream();
            try {
                string = IOUtils.toString((InputStream)is, (String)"UTF-8");
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new NestedIOException(ioe);
                }
            }
            is.close();
        }
        return string;
    }

    private DocStream getExtensionDocStream(String path) {
        return this.bdfServer.getResourceStorages().getResourceDocStream(NssDialogues.EXTENSION_RESOURCE_ROOT.buildChild(path));
    }

    private FicheMeta createFiche(Properties properties, BdfParameters bdfParameters) {
        FicheMeta ficheMeta = null;
        try (EditSession editSession = this.bdfServer.initEditSession("ext:NssDialogues");){
            CorpusEditor corpusEditor = editSession.getFichothequeEditor().getCorpusEditor(corpusKey);
            try {
                ficheMeta = corpusEditor.createFiche(-1);
            }
            catch (ExistingIdException eii) {
                throw new ImplementationException((Exception)((Object)eii));
            }
            catch (NoMasterIdException nmie) {
                throw new ShouldNotOccurException((Exception)((Object)nmie));
            }
            AppendableRequestMap appendableRequestMap = new AppendableRequestMap(this.requestMap);
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String key = entry.getKey().toString();
                String value = entry.getValue().toString();
                if (!key.startsWith("champ_")) continue;
                appendableRequestMap.setParameter(key.substring(6), value);
            }
            EditionEngine.replace((EditSession)editSession, (BdfParameters)bdfParameters, (RequestMap)appendableRequestMap, (FicheMeta)ficheMeta);
        }
        this.envoi(ficheMeta);
        return ficheMeta;
    }

    private void envoi(FicheMeta ficheMeta) {
        FicheItem ficheItem;
        BdfUser fromBdfUser = this.getFromBdfUser();
        DefaultBdfParameters bdfParameters = new DefaultBdfParameters(this.bdfServer, fromBdfUser);
        EmailBuffer emailBuffer = EmailBuffer.buildForFiche((BdfServer)this.bdfServer, (BdfUser)fromBdfUser, (FicheMeta)ficheMeta).setSubject("Confirmation de la saisie de propositions").setWithRedacteurBcc(true).setMessage(this.getText());
        Prop courriel = ficheMeta.getFicheAPI(false).getProp(courrielKey);
        if (courriel != null && (ficheItem = courriel.getFicheItem()) instanceof EmailItem) {
            EmailCore emailCore = ((EmailItem)ficheItem).getEmailCore();
            emailBuffer.addValidAddress("to", new ValidAddress(emailCore));
            SendEngine sendEngine = SendEngine.build((BdfParameters)bdfParameters);
            sendEngine.sendEmail(emailBuffer);
        }
    }

    private BdfUser getFromBdfUser() {
        try {
            Redacteur redacteur = this.bdfServer.getFichothequeQuestioner().getRedacteurByLogin("VIC[admin]");
            return this.bdfServer.createBdfUser(redacteur);
        }
        catch (UserLoginException e) {
            return null;
        }
    }
}

