/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.icyce.contentstreams;

import fr.exemole.bdfext.icyce.GroupementPays;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.users.BdfUser;
import net.fichotheque.Fichotheque;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.CountryItem;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.geoloc.GeolocUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.localisation.UserLangContext;
import net.mapeadores.util.primitives.DegrePoint;
import net.mapeadores.util.text.StringUtils;

public class PaysJs {
    private final BdfServer bdfServer;
    private final Fichotheque fichotheque;
    private final Lang workingLang;
    private final BdfUser bdfUser;
    private final StringBuilder buf;

    private PaysJs(BdfServer bdfServer, BdfUser bdfUser, StringBuilder buf) {
        this.bdfServer = bdfServer;
        this.bdfUser = bdfUser;
        this.buf = buf;
        this.fichotheque = bdfServer.getFichotheque();
        this.workingLang = bdfUser.getWorkingLang();
    }

    private void write() {
        GroupementPays groupementPays = new GroupementPays(this.fichotheque);
        Thesaurus masterThesaurus = (Thesaurus)groupementPays.getCorpus().getMasterSubset();
        this.print("function initGeolocalisation() {\n\tGEO_InitCarte();\n");
        int length = groupementPays.getPaysCount();
        MessageLocalisation messageLocalisation = this.bdfServer.getL10nManager().getMessageLocalisation((UserLangContext)this.bdfUser);
        for (int i = 0; i < length; ++i) {
            GroupementPays.PaysItem gppi = groupementPays.getPaysItem(i);
            CountryItem pays = gppi.getPays();
            this.print("\tGEO_CreateMarqueur(");
            DegrePoint degrePoint = GeolocUtils.getCountryGeoloc((String)pays.getCountry().toString());
            this.print(degrePoint.getLatitude().toString());
            this.virgule();
            this.buf.append(degrePoint.getLongitude().toString());
            this.virgule();
            this.apos();
            this.escape(StringUtils.getFirstPart((String)messageLocalisation.toString(pays.getCountry().toString())));
            this.apos();
            this.virgule();
            this.apos();
            this.print(pays.getCountry().toString());
            this.apos();
            this.virgule();
            this.apos();
            int abCount = gppi.getFicheMetaCount();
            for (int j = 0; j < abCount; ++j) {
                FicheMeta ficheMeta = gppi.getFicheMeta(j);
                int ficheid = ficheMeta.getId();
                if (j > 0) {
                    this.print('|');
                }
                this.print(String.valueOf(ficheMeta.getId()));
                this.print('=');
                Motcle motcle = masterThesaurus.getMotcleById(ficheid);
                this.escape(motcle.getLabelString(this.workingLang));
            }
            this.apos();
            this.print(");\n");
        }
        this.print("}\n");
    }

    private void virgule() {
        this.buf.append(",");
    }

    private void apos() {
        this.buf.append("\"");
    }

    private void print(String s) {
        this.buf.append(s);
    }

    private void print(char carac) {
        this.buf.append(carac);
    }

    private void escape(String s) {
        int c = s.length();
        block3: for (int i = 0; i < c; ++i) {
            char carac = s.charAt(i);
            switch (carac) {
                case '\"': {
                    this.print("\\\"");
                    continue block3;
                }
                default: {
                    this.print(carac);
                }
            }
        }
    }

    public static String getString(BdfServer bdfServer, BdfUser bdfUser) {
        StringBuilder buf = new StringBuilder();
        PaysJs paysJs = new PaysJs(bdfServer, bdfUser, buf);
        return buf.toString();
    }
}

