/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.icyce;

import fr.exemole.bdfext.icyce.Icyce;
import fr.exemole.bdfext.icyce.IcyceConstants;
import fr.exemole.bdfext.icyce.contentstreams.PaysJs;
import fr.exemole.bdfext.icyce.htmlpages.ConferencePage;
import fr.exemole.bdfext.icyce.htmlpages.ConfirmationBoutonPage;
import fr.exemole.bdfext.icyce.htmlpages.ConfirmationEnvoiPage;
import fr.exemole.bdfext.icyce.htmlpages.IndexPage;
import fr.exemole.bdfext.icyce.htmlpages.ListePage;
import fr.exemole.bdfext.icyce.htmlpages.MesconfsPage;
import fr.exemole.bdfext.icyce.htmlpages.ParlanguePage;
import fr.exemole.bdfext.icyce.htmlpages.SpherePage;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfInstruction;
import fr.exemole.bdfserver.api.instruction.BdfInstructionConstants;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.tools.users.BdfUserUtils;
import net.mapeadores.util.html.HtmlProducer;
import net.mapeadores.util.servlets.ResponseHandler;
import net.mapeadores.util.servlets.handlers.HtmlResponseHandler;
import net.mapeadores.util.servlets.handlers.SimpleResponseHandler;

public class IcyceBdfInstruction
implements BdfInstruction,
IcyceConstants,
BdfInstructionConstants {
    private final short action;
    private final String param;
    private final BdfServer bdfServer;
    private BdfUser bdfUser;

    public IcyceBdfInstruction(BdfServer bdfServer, short action, String param) {
        this.action = action;
        this.param = param;
        this.bdfServer = bdfServer;
    }

    public short getBdfUserNeed() {
        return 3;
    }

    private boolean testInit(short action, BdfUser bdfUser) {
        if (action != 1) {
            return false;
        }
        return BdfUserUtils.isAdmin((BdfServer)this.bdfServer, (BdfUser)bdfUser);
    }

    public ResponseHandler runInstruction(BdfUser bdfUser) {
        if (!Icyce.isInit() || this.testInit(this.action, bdfUser)) {
            Icyce.init(this.bdfServer);
        }
        this.bdfUser = bdfUser;
        switch (this.action) {
            case 3: {
                return SimpleResponseHandler.init((String)PaysJs.getString(this.bdfServer, bdfUser), (String)"text/javascript");
            }
            case 1: {
                return HtmlResponseHandler.init((HtmlProducer)new IndexPage(this.bdfServer, bdfUser));
            }
            case 2: {
                return HtmlResponseHandler.init((HtmlProducer)SpherePage.newInstance(this.bdfServer, bdfUser, this.param));
            }
            case 4: {
                return HtmlResponseHandler.init((HtmlProducer)new ListePage(this.bdfServer, bdfUser));
            }
            case 5: {
                return HtmlResponseHandler.init((HtmlProducer)ConferencePage.newInstance(this.bdfServer, bdfUser, this.param));
            }
            case 6: {
                return HtmlResponseHandler.init((HtmlProducer)new ParlanguePage(this.bdfServer, bdfUser));
            }
            case 7: {
                return HtmlResponseHandler.init((HtmlProducer)new MesconfsPage(this.bdfServer, bdfUser));
            }
            case 8: {
                return HtmlResponseHandler.init((HtmlProducer)ConfirmationBoutonPage.newInstance(this.bdfServer, bdfUser, this.param));
            }
            case 9: {
                return HtmlResponseHandler.init((HtmlProducer)ConfirmationEnvoiPage.newInstance(this.bdfServer, bdfUser, this.param));
            }
        }
        return null;
    }
}

