/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.tablesexport;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.sxio.SXContentSource;
import net.desmodo.atlas.sxio.SXIO;
import net.desmodo.atlas.sxio.SXIOException;
import net.desmodo.atlas.sxio.SXStylesSource;
import net.desmodo.atlas.sxio.StringSXStylesSource;
import net.desmodo.atlas.tablesexport.AtlasSxcWriter;

public class AtlasSxcExport {
    private final Atlas atlas;

    public AtlasSxcExport(Atlas atlas) {
        this.atlas = atlas;
    }

    public void exportSxc(OutputStream outputStream) throws IOException {
        AtlasContentSource atlasContentSource = new AtlasContentSource();
        try {
            SXIO.write(outputStream, (SXContentSource)atlasContentSource, (SXStylesSource)new StringSXStylesSource("<office:style></office:style>"));
        }
        catch (SXIOException sXIOException) {
            // empty catch block
        }
    }

    private class AtlasContentSource
    implements SXContentSource {
        AtlasContentSource() {
        }

        @Override
        public void writeContent(OutputStream outputStream) throws SXIOException {
            try {
                BufferedWriter bufwriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
                bufwriter.write("<office:body>");
                bufwriter.newLine();
                AtlasSxcWriter sxcWriter = new AtlasSxcWriter();
                sxcWriter.setAppendable(bufwriter);
                sxcWriter.setIndentLength(0);
                sxcWriter.writeAtlas(AtlasSxcExport.this.atlas);
                bufwriter.write("</office:body>");
                bufwriter.newLine();
                bufwriter.flush();
            }
            catch (IOException ioe) {
                throw new SXIOException(ioe);
            }
        }

        @Override
        public String getEncoding() {
            return "UTF-8";
        }

        @Override
        public String getFormatName() {
            return "sxc";
        }

        @Override
        public boolean needDeclaration() {
            return true;
        }

        @Override
        public boolean needRootElement() {
            return true;
        }
    }
}

