/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.display.secteurs.secteurangulaire;

import net.mapeadores.util.geometry.CartesianUtils;

public class FaisceauAngleInfo {
    private final boolean tourComplet;
    private final double cartesianStartAngle;
    private final double cartesianFaisceauAngle;
    private double cartesianSecteurAngle;
    private int graphicSecteurAngle;
    private int graphicStartAngle;

    public FaisceauAngleInfo(double cartesianStartAngle, double cartesianFaisceauAngle, int secteurCount) {
        this.tourComplet = Math.abs(cartesianFaisceauAngle) >= Math.PI * 2;
        this.cartesianStartAngle = CartesianUtils.modulo2pi((double)cartesianStartAngle);
        this.cartesianFaisceauAngle = this.tourComplet ? Math.PI * 2 : CartesianUtils.modulo2pi((double)cartesianFaisceauAngle);
        this.init(secteurCount);
    }

    private void init(int secteurCount) {
        if (secteurCount > 0) {
            this.cartesianSecteurAngle = this.cartesianFaisceauAngle / (double)secteurCount;
        }
        this.graphicSecteurAngle = (int)Math.round(Math.toDegrees(this.cartesianSecteurAngle));
        if (this.graphicSecteurAngle == 0) {
            this.graphicSecteurAngle = 360;
        }
        this.graphicStartAngle = (int)Math.round(Math.toDegrees(this.cartesianStartAngle));
    }

    public double getCartesianFaisceauAngle() {
        return this.cartesianFaisceauAngle;
    }

    public double getCartesianStartAngle() {
        return this.cartesianStartAngle;
    }

    public int getGraphicStartAngle() {
        return this.graphicStartAngle;
    }

    public double getCartesianSecteurAngle() {
        return this.cartesianSecteurAngle;
    }

    public int getGraphicSecteurAngle() {
        return this.graphicSecteurAngle;
    }
}

