/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmoservice.atlas.engines;

import fr.exemole.bdfext.desmoservice.atlas.BdfAtlas;
import net.fichotheque.ExistingIdException;
import net.fichotheque.Fichotheque;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.CorpusEditor;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.NoMasterIdException;
import net.fichotheque.corpus.fiche.Fiche;
import net.fichotheque.corpus.fiche.FicheAPI;
import net.fichotheque.junction.Junction;
import net.fichotheque.junction.JunctionEditor;
import net.fichotheque.junction.Junctions;
import net.fichotheque.junction.Tie;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.junction.JunctionChangeEngine;
import net.mapeadores.util.exceptions.ShouldNotOccurException;

public final class EngineUtils {
    private EngineUtils() {
    }

    public static boolean isPere(Junction junction) {
        for (Tie tie : junction.getTieList()) {
            if (!tie.getMode().equals("pere")) continue;
            return true;
        }
        return false;
    }

    public static int isFils(Junction junction) {
        for (Tie tie : junction.getTieList()) {
            if (!tie.getMode().equals("fils")) continue;
            return tie.getWeight();
        }
        return -1;
    }

    public static void setLienHierarchique(BdfAtlas bdfAtlas, FichothequeEditor fichothequeEditor, Motcle pere, Motcle contexte, Motcle fils) {
        EngineUtils.setLienHierarchique(fichothequeEditor, pere, contexte, fils, bdfAtlas.lienhierarchiqueCorpus, bdfAtlas.grilleThesaurus, bdfAtlas.descripteurThesaurus);
    }

    public static void setLienHierarchique(FichothequeEditor fichothequeEditor, Motcle pere, Motcle contexte, Motcle fils, Corpus lienhierarchiqueCorpus, Thesaurus grilleThesaurus, Thesaurus descripteurThesaurus) {
        FicheMeta ficheMeta;
        Fichotheque fichotheque = fichothequeEditor.getFichotheque();
        Junctions lienJunctions = fichotheque.getJunctions((SubsetItem)pere, (Subset)lienhierarchiqueCorpus);
        FicheMeta lienhierarchique = null;
        block3: for (Junctions.Entry lienEntry : lienJunctions.getEntryList()) {
            ficheMeta = (FicheMeta)lienEntry.getSubsetItem();
            if (!EngineUtils.isPere(lienEntry.getJunction())) continue;
            Junctions contexteJunctions = fichotheque.getJunctions((SubsetItem)ficheMeta, (Subset)grilleThesaurus);
            for (Junctions.Entry contexteEntry : contexteJunctions.getEntryList()) {
                if (!contexteEntry.getSubsetItem().equals(contexte)) continue;
                lienhierarchique = ficheMeta;
                continue block3;
            }
        }
        JunctionEditor junctionEditor = fichothequeEditor.getJunctionEditor();
        if (lienhierarchique == null) {
            CorpusEditor corpusEditor = fichothequeEditor.getCorpusEditor(lienhierarchiqueCorpus);
            try {
                ficheMeta = corpusEditor.createFiche(-1);
            }
            catch (ExistingIdException eie) {
                throw new ShouldNotOccurException("Test done before");
            }
            catch (NoMasterIdException nmie) {
                throw new ShouldNotOccurException("Not a satellite subset");
            }
            JunctionChangeEngine engine = JunctionChangeEngine.clearExistingEngine((SubsetItem)ficheMeta);
            engine.addTie((SubsetItem)pere, "pere", 1);
            engine.addTie((SubsetItem)contexte, "", 1);
            engine.addTie((SubsetItem)fils, "fils", 1);
            junctionEditor.updateJunctions((SubsetItem)ficheMeta, engine.toJunctionChanges());
            corpusEditor.saveFiche(ficheMeta, (FicheAPI)new Fiche());
        } else {
            Junctions currentFilsJunctions = fichotheque.getJunctions(lienhierarchique, (Subset)descripteurThesaurus);
            boolean existing = false;
            int weightMax = 0;
            for (Junctions.Entry currentFilsEntry : currentFilsJunctions.getEntryList()) {
                Junction junction = currentFilsEntry.getJunction();
                Tie tie = junction.getTieByMode("fils");
                if (tie == null) continue;
                if (currentFilsEntry.getSubsetItem().equals(fils)) {
                    existing = true;
                    break;
                }
                weightMax = Math.max(weightMax, tie.getWeight());
            }
            if (!existing) {
                JunctionChangeEngine junctionChangeEngine = JunctionChangeEngine.appendEngine(lienhierarchique);
                junctionChangeEngine.addTie((SubsetItem)fils, "fils", weightMax + 1);
                junctionEditor.updateJunctions((SubsetItem)lienhierarchique, junctionChangeEngine.toJunctionChanges());
            }
        }
    }

    public static Motcle getContexteMotcle(FicheMeta lienhierarchique, BdfAtlas bdfAtlas) {
        Junctions contexteJunctions = lienhierarchique.getFichotheque().getJunctions((SubsetItem)lienhierarchique, (Subset)bdfAtlas.grilleThesaurus);
        return (Motcle)contexteJunctions.getFirstSubsetItem();
    }
}

