/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmoservice.atlas.engines;

import fr.exemole.bdfext.desmoservice.atlas.BdfAtlas;
import fr.exemole.bdfext.desmoservice.atlas.BdfAtlasUtils;
import fr.exemole.bdfext.desmoservice.atlas.engines.EngineUtils;
import java.util.ArrayList;
import java.util.Set;
import net.fichotheque.Fichotheque;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.junction.Junction;
import net.fichotheque.junction.JunctionEditor;
import net.fichotheque.junction.Junctions;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.ParentRecursivityException;
import net.fichotheque.tools.FichothequeTools;
import net.fichotheque.tools.junction.JunctionChangeEngine;
import net.fichotheque.tools.thesaurus.ThesaurusTools;
import net.mapeadores.util.localisation.Langs;

class DescripteursMergeEngine {
    private final BdfAtlas bdfAtlas;
    private final Fichotheque fichotheque;
    private final FichothequeEditor fichothequeEditor;
    private final JunctionEditor junctionEditor;
    private final Motcle destinationDescripteur;
    private final Set<Motcle> originSet;
    private final Langs langs;

    DescripteursMergeEngine(BdfAtlas bdfAtlas, FichothequeEditor fichothequeEditor, Motcle destinationDescripteur, Set<Motcle> originSet, Langs langs) {
        this.bdfAtlas = bdfAtlas;
        this.fichothequeEditor = fichothequeEditor;
        this.fichotheque = fichothequeEditor.getFichotheque();
        this.junctionEditor = fichothequeEditor.getJunctionEditor();
        this.destinationDescripteur = destinationDescripteur;
        this.originSet = originSet;
        this.langs = langs;
    }

    void run() {
        this.cleanFils(this.destinationDescripteur);
        for (Motcle originDescripteur : this.originSet) {
            this.cleanFils(originDescripteur);
        }
        for (Motcle originDescripteur : this.originSet) {
            this.moveLienhierarchique(originDescripteur);
            try {
                ThesaurusTools.merge((FichothequeEditor)this.fichothequeEditor, (Motcle)originDescripteur, (Motcle)this.destinationDescripteur, (Langs)this.langs);
            }
            catch (ParentRecursivityException pre) {
                throw new IllegalStateException("destinationDescripteur is child of origin descripteur");
            }
        }
    }

    private void cleanFils(Motcle descripteur) {
        ArrayList<Motcle> removeList = new ArrayList<Motcle>();
        ArrayList<FicheMeta> lienRemoveList = new ArrayList<FicheMeta>();
        Junctions lienJunctions = this.fichotheque.getJunctions((SubsetItem)descripteur, (Subset)this.bdfAtlas.lienhierarchiqueCorpus);
        for (Junctions.Entry lienEntry : lienJunctions.getEntryList()) {
            Junction junction = lienEntry.getJunction();
            boolean pere = EngineUtils.isPere(junction);
            int fils = EngineUtils.isFils(junction);
            if (!pere && fils == -1) continue;
            FicheMeta lienhierarchique = (FicheMeta)lienEntry.getSubsetItem();
            Junctions otherJunctions = this.fichotheque.getJunctions((SubsetItem)lienhierarchique, (Subset)this.bdfAtlas.descripteurThesaurus);
            boolean originIsDescripteurPere = false;
            for (Junctions.Entry otherEntry : otherJunctions.getEntryList()) {
                Motcle otherDescripteur = (Motcle)otherEntry.getSubsetItem();
                if (otherDescripteur.equals(descripteur) || !this.originSet.contains(otherDescripteur)) continue;
                if (EngineUtils.isFils(otherEntry.getJunction()) != -1) {
                    removeList.add(otherDescripteur);
                }
                if (!EngineUtils.isPere(otherEntry.getJunction())) continue;
                originIsDescripteurPere = true;
            }
            for (Motcle otherDescripteur : removeList) {
                this.junctionEditor.updateJunction((SubsetItem)lienhierarchique, (SubsetItem)otherDescripteur, BdfAtlasUtils.FILSREMOVE_JUNCTIONCHANGE);
            }
            removeList.clear();
            if (fils == -1 || !originIsDescripteurPere) continue;
            lienRemoveList.add(lienhierarchique);
        }
        for (FicheMeta lienhierarchique : lienRemoveList) {
            this.junctionEditor.updateJunction((SubsetItem)lienhierarchique, (SubsetItem)descripteur, BdfAtlasUtils.FILSREMOVE_JUNCTIONCHANGE);
        }
    }

    private void moveLienhierarchique(Motcle descripteur) {
        Junctions lienJunctions = this.fichotheque.getJunctions((SubsetItem)descripteur, (Subset)this.bdfAtlas.lienhierarchiqueCorpus);
        ArrayList<FicheMeta> removeList = new ArrayList<FicheMeta>();
        for (Junctions.Entry entry : lienJunctions.getEntryList()) {
            Junction junction = entry.getJunction();
            boolean pere = EngineUtils.isPere(junction);
            int fils = EngineUtils.isFils(junction);
            if (!pere && fils == -1) continue;
            FicheMeta lienhierarchique = (FicheMeta)entry.getSubsetItem();
            Motcle contexte = EngineUtils.getContexteMotcle(lienhierarchique, this.bdfAtlas);
            if (pere) {
                Junctions otherJunctions = this.fichotheque.getJunctions((SubsetItem)lienhierarchique, (Subset)this.bdfAtlas.descripteurThesaurus);
                for (Junctions.Entry otherEntry : otherJunctions.getEntryList()) {
                    Motcle otherDescripteur = (Motcle)otherEntry.getSubsetItem();
                    EngineUtils.setLienHierarchique(this.bdfAtlas, this.fichothequeEditor, this.destinationDescripteur, contexte, otherDescripteur);
                }
                removeList.add(lienhierarchique);
                continue;
            }
            JunctionChangeEngine junctionChangeEngine = JunctionChangeEngine.appendEngine((SubsetItem)lienhierarchique);
            junctionChangeEngine.addTie((SubsetItem)this.destinationDescripteur, "fils", fils);
            this.junctionEditor.updateJunctions((SubsetItem)lienhierarchique, junctionChangeEngine.toJunctionChanges());
        }
        for (FicheMeta lienhierarchique : removeList) {
            FichothequeTools.remove((FichothequeEditor)this.fichothequeEditor, (FicheMeta)lienhierarchique);
        }
    }
}

