/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmoservice.atlas.engines;

import fr.exemole.bdfext.desmoservice.api.AtlasEdition;
import fr.exemole.bdfext.desmoservice.atlas.BdfAtlas;
import fr.exemole.bdfext.desmoservice.atlas.BdfAtlasUtils;
import fr.exemole.bdfext.desmoservice.atlas.engines.DescripteursMergeEngine;
import fr.exemole.bdfext.desmoservice.atlas.engines.EngineUtils;
import fr.exemole.bdfserver.api.BdfServer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import net.fichotheque.ExistingIdException;
import net.fichotheque.Fichotheque;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.junction.JunctionEditor;
import net.fichotheque.junction.Junctions;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.ThesaurusEditor;
import net.fichotheque.tools.FichothequeTools;
import net.fichotheque.tools.junction.JunctionChangeEngine;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeChange;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.localisation.LocalisationUtils;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.LabelChange;

public class BdfAtlasEditionEngine {
    private final BdfAtlas bdfAtlas;
    private final BdfServer bdfServer;
    private final FichothequeEditor fichothequeEditor;
    private final MessageHandler messageHandler;
    private final Map<AtlasEdition.DescripteurCreation, Motcle> creationMap = new HashMap<AtlasEdition.DescripteurCreation, Motcle>();
    private final Map<String, Integer> availableIdMap = new HashMap<String, Integer>();

    public BdfAtlasEditionEngine(BdfAtlas bdfAtlas, BdfServer bdfServer, FichothequeEditor fichothequeEditor, MessageHandler messageHandler) {
        this.bdfAtlas = bdfAtlas;
        this.bdfServer = bdfServer;
        this.fichothequeEditor = fichothequeEditor;
        this.messageHandler = messageHandler;
    }

    public void runEdition(AtlasEdition atlasEdition) {
        AtlasEdition.EditionUnit unit;
        int i;
        int editionUnitCount = atlasEdition.getEditionUnitCount();
        for (i = 0; i < editionUnitCount; ++i) {
            unit = atlasEdition.getEditionUnit(i);
            if (unit instanceof AtlasEdition.TermChange) {
                this.runTermChange((AtlasEdition.TermChange)unit);
                continue;
            }
            if (unit instanceof AtlasEdition.LienHierarchiqueCreation) {
                this.runLienHierarchiqueCreation((AtlasEdition.LienHierarchiqueCreation)unit);
                continue;
            }
            if (unit instanceof AtlasEdition.DescripteurCreation) {
                this.createDescripteur((AtlasEdition.DescripteurCreation)unit);
                continue;
            }
            if (unit instanceof AtlasEdition.ContexteLienHierarchiqueChange) {
                this.runContexteLienHierarchiqueChange((AtlasEdition.ContexteLienHierarchiqueChange)unit);
                continue;
            }
            if (unit instanceof AtlasEdition.DescripteursMerge) {
                this.runDescripteursMerge((AtlasEdition.DescripteursMerge)unit);
                continue;
            }
            if (!(unit instanceof AtlasEdition.LienHierarchiqueRemove)) continue;
            this.runLienHierarchiqueRemove((AtlasEdition.LienHierarchiqueRemove)unit);
        }
        for (i = 0; i < editionUnitCount; ++i) {
            unit = atlasEdition.getEditionUnit(i);
            if (!(unit instanceof AtlasEdition.TermRemove)) continue;
            this.runTermRemove((AtlasEdition.TermRemove)unit);
        }
    }

    private void runTermRemove(AtlasEdition.TermRemove termRemove) {
        int code = termRemove.getCode();
        short type = BdfAtlasUtils.getTypeFromTermCode(code);
        if (type != 1) {
            return;
        }
        Motcle motcle = this.bdfAtlas.getMotcle(type, BdfAtlasUtils.getIdFromTermCode(code));
        if (motcle == null) {
            this.addCodeError("_ error.unknown.fr-exemole-desmoservice.code", code, "termeChange");
            return;
        }
        Junctions lienJunctions = motcle.getFichotheque().getJunctions((SubsetItem)motcle, (Subset)this.bdfAtlas.lienhierarchiqueCorpus);
        ArrayList<FicheMeta> ficheToRemoveList = new ArrayList<FicheMeta>();
        for (Junctions.Entry entry : lienJunctions.getEntryList()) {
            FicheMeta ficheMeta = (FicheMeta)entry.getSubsetItem();
            if (!EngineUtils.isPere(entry.getJunction())) continue;
            ficheToRemoveList.add(ficheMeta);
        }
        if (!ficheToRemoveList.isEmpty()) {
            for (FicheMeta ficheMeta : ficheToRemoveList) {
                FichothequeTools.remove((FichothequeEditor)this.fichothequeEditor, (FicheMeta)ficheMeta);
            }
        }
        FichothequeTools.remove((FichothequeEditor)this.fichothequeEditor, (Motcle)motcle);
    }

    private void runTermChange(AtlasEdition.TermChange termChange) {
        int id;
        int code = termChange.getCode();
        short type = BdfAtlasUtils.getTypeFromTermCode(code);
        Motcle motcle = this.bdfAtlas.getMotcle(type, id = BdfAtlasUtils.getIdFromTermCode(code));
        if (motcle == null) {
            this.addCodeError("_ error.unknown.fr-exemole-desmoservice.code", code, "termeChange");
            return;
        }
        AttributeChange attributeChange = termChange.getAttributeChange();
        for (Attribute attribute : attributeChange.getChangedAttributes()) {
            this.fichothequeEditor.putAttribute((Object)motcle, attribute);
        }
        for (AttributeKey removedAttributeKey : attributeChange.getRemovedAttributeKeyList()) {
            this.fichothequeEditor.removeAttribute((Object)motcle, removedAttributeKey);
        }
        LabelChange labelChange = termChange.getLabelChange();
        ThesaurusEditor thesaurusEditor = this.fichothequeEditor.getThesaurusEditor(motcle.getSubsetKey());
        for (Label label : labelChange.getChangedLabels()) {
            thesaurusEditor.putLabel(motcle, label);
        }
        for (Lang lang : labelChange.getRemovedLangList()) {
            thesaurusEditor.removeLabel(motcle, lang);
        }
        if (type == 1) {
            Motcle familleMotcle;
            int codefamille = termChange.getCodefamille();
            if (codefamille == 0) {
                JunctionEditor junctionEditor = this.fichothequeEditor.getJunctionEditor();
                JunctionChangeEngine engine = JunctionChangeEngine.clearExistingEngine((SubsetItem)motcle, Collections.singleton(IncludeKey.newInstance((SubsetKey)this.bdfAtlas.familleThesaurus.getSubsetKey(), (String)"", (int)1)));
                junctionEditor.updateJunctions((SubsetItem)motcle, engine.toJunctionChanges());
            } else if (codefamille > 0 && (familleMotcle = this.getFamilleMotcle(codefamille)) != null) {
                JunctionEditor junctionEditor = this.fichothequeEditor.getJunctionEditor();
                JunctionChangeEngine engine = JunctionChangeEngine.clearExistingEngine((SubsetItem)motcle);
                engine.addTie((SubsetItem)familleMotcle, "", 1);
                junctionEditor.updateJunctions((SubsetItem)motcle, engine.toJunctionChanges());
            }
        }
    }

    private void runLienHierarchiqueCreation(AtlasEdition.LienHierarchiqueCreation lienHierarchiqueCreation) {
        Motcle pereMotcle = this.getDescripteurMotcle(lienHierarchiqueCreation.getDescriteurPereCode(), "DescripteurPere");
        if (pereMotcle == null) {
            return;
        }
        Motcle contexteMotcle = this.getContexteMotcle(lienHierarchiqueCreation.getContexteCode());
        if (contexteMotcle == null) {
            return;
        }
        int filsCode = lienHierarchiqueCreation.getDescripteurFilsCode();
        Motcle filsMotcle = filsCode != -1 ? this.getDescripteurMotcle(filsCode, "DescripteurFils") : this.createDescripteur(lienHierarchiqueCreation.getDescripteurFilsCreation());
        EngineUtils.setLienHierarchique(this.bdfAtlas, this.fichothequeEditor, pereMotcle, contexteMotcle, filsMotcle);
    }

    private void runContexteLienHierarchiqueChange(AtlasEdition.ContexteLienHierarchiqueChange contexteLienHierarchiqueChange) {
        Motcle pereMotcle = this.getDescripteurMotcle(contexteLienHierarchiqueChange.getDescriteurPereCode(), "DescripteurPere");
        if (pereMotcle == null) {
            return;
        }
        Motcle contexteMotcle = this.getContexteMotcle(contexteLienHierarchiqueChange.getNewContexteCode());
        if (contexteMotcle == null) {
            return;
        }
        Motcle filsMotcle = this.getDescripteurMotcle(contexteLienHierarchiqueChange.getDescripteurFilsCode(), "DescripteurFils");
        if (filsMotcle == null) {
            return;
        }
        this.removeLienHierarchique(pereMotcle, null, filsMotcle);
        EngineUtils.setLienHierarchique(this.bdfAtlas, this.fichothequeEditor, pereMotcle, contexteMotcle, filsMotcle);
    }

    private void runLienHierarchiqueRemove(AtlasEdition.LienHierarchiqueRemove lienHierarchiqueRemove) {
        Motcle pereMotcle = this.getDescripteurMotcle(lienHierarchiqueRemove.getDescriteurPereCode(), "DescripteurPere");
        if (pereMotcle == null) {
            return;
        }
        Motcle contexteMotcle = this.getContexteMotcle(lienHierarchiqueRemove.getContexteCode());
        if (contexteMotcle == null) {
            return;
        }
        Motcle filsMotcle = this.getDescripteurMotcle(lienHierarchiqueRemove.getDescripteurFilsCode(), "DescripteurFils");
        if (filsMotcle == null) {
            return;
        }
        this.removeLienHierarchique(pereMotcle, contexteMotcle, filsMotcle);
    }

    private Motcle createDescripteur(AtlasEdition.DescripteurCreation descripteurCreation) {
        Motcle familleMotcle;
        Motcle descripteurMotcle;
        String newIdalpha;
        Motcle existing = this.creationMap.get(descripteurCreation);
        if (existing != null) {
            return existing;
        }
        Thesaurus descripteurThesaurus = this.bdfAtlas.descripteurThesaurus;
        String keyPrefix = descripteurCreation.getKeyPrefix();
        String prefix = this.bdfAtlas.atlasPrefix + keyPrefix;
        int availableId = this.getAvailableId(keyPrefix);
        while (descripteurThesaurus.getMotcleByIdalpha(newIdalpha = prefix + availableId) != null) {
            ++availableId;
        }
        this.setAvailableId(keyPrefix, ++availableId);
        ThesaurusEditor thesaurusEditor = this.fichothequeEditor.getThesaurusEditor(descripteurThesaurus);
        try {
            descripteurMotcle = thesaurusEditor.createMotcle(-1, newIdalpha);
        }
        catch (ExistingIdException eie) {
            throw new ShouldNotOccurException("Test done before");
        }
        catch (ParseException pe) {
            throw new ShouldNotOccurException("Good idalpha : " + newIdalpha);
        }
        for (Attribute attribute : descripteurCreation.getAttributes()) {
            this.fichothequeEditor.putAttribute((Object)descripteurMotcle, attribute);
        }
        for (Label label : descripteurCreation.getLabels()) {
            thesaurusEditor.putLabel(descripteurMotcle, label);
        }
        int codefamille = descripteurCreation.getCodefamille();
        if (codefamille > 0 && (familleMotcle = this.getFamilleMotcle(codefamille)) != null) {
            JunctionEditor junctionEditor = this.fichothequeEditor.getJunctionEditor();
            JunctionChangeEngine engine = JunctionChangeEngine.clearExistingEngine((SubsetItem)descripteurMotcle);
            engine.addTie((SubsetItem)familleMotcle, "", 1);
            junctionEditor.updateJunctions((SubsetItem)descripteurMotcle, engine.toJunctionChanges());
        }
        this.creationMap.put(descripteurCreation, descripteurMotcle);
        return descripteurMotcle;
    }

    private void removeLienHierarchique(Motcle pere, Motcle contexte, Motcle fils) {
        Fichotheque fichotheque = this.fichothequeEditor.getFichotheque();
        Junctions lienJunctions = fichotheque.getJunctions((SubsetItem)pere, (Subset)this.bdfAtlas.lienhierarchiqueCorpus);
        JunctionEditor junctionEditor = this.fichothequeEditor.getJunctionEditor();
        block0: for (Junctions.Entry lienEntry : lienJunctions.getEntryList()) {
            FicheMeta ficheMeta = (FicheMeta)lienEntry.getSubsetItem();
            if (!EngineUtils.isPere(lienEntry.getJunction())) continue;
            if (contexte != null) {
                Junctions contexteJunctions = fichotheque.getJunctions((SubsetItem)ficheMeta, (Subset)this.bdfAtlas.grilleThesaurus);
                for (Junctions.Entry contexteEntry : contexteJunctions.getEntryList()) {
                    if (!contexteEntry.getSubsetItem().equals(contexte)) continue;
                    junctionEditor.updateJunction((SubsetItem)ficheMeta, (SubsetItem)fils, BdfAtlasUtils.FILSREMOVE_JUNCTIONCHANGE);
                    continue block0;
                }
                continue;
            }
            junctionEditor.updateJunction((SubsetItem)ficheMeta, (SubsetItem)fils, BdfAtlasUtils.FILSREMOVE_JUNCTIONCHANGE);
        }
    }

    private void runDescripteursMerge(AtlasEdition.DescripteursMerge descripteursMerge) {
        Motcle destinationMotcle = this.getDescripteurMotcle(descripteursMerge.getDestinationDescripteurCode(), "DestinationDescripteur");
        if (destinationMotcle == null) {
            return;
        }
        int originCount = descripteursMerge.getOriginDescripteurCount();
        if (originCount == 0) {
            return;
        }
        LinkedHashSet<Motcle> originSet = new LinkedHashSet<Motcle>();
        for (int i = 0; i < originCount; ++i) {
            Motcle origin = this.getDescripteurMotcle(descripteursMerge.getOriginDescripteurCode(i), "OriginDescripteur");
            if (origin == null) {
                return;
            }
            if (origin.equals(destinationMotcle)) continue;
            originSet.add(origin);
        }
        Langs langs = this.bdfServer.getThesaurusLangChecker().getAuthorizedLangs(destinationMotcle.getThesaurus());
        DescripteursMergeEngine engine = new DescripteursMergeEngine(this.bdfAtlas, this.fichothequeEditor, destinationMotcle, originSet, langs);
        engine.run();
    }

    private Motcle getDescripteurMotcle(int code, String position) {
        return this.getMotcle((short)1, code, position);
    }

    private Motcle getContexteMotcle(int code) {
        return this.getMotcle((short)3, code, "Contexte");
    }

    private Motcle getFamilleMotcle(int code) {
        return this.getMotcle((short)4, code, "Famille");
    }

    private Motcle getMotcle(short type, int code, String position) {
        short codeType = BdfAtlasUtils.getTypeFromTermCode(code);
        if (codeType != type) {
            this.addCodeError("_ error.wrong.fr-exemole-desmoservice.code_type", code, position);
            return null;
        }
        int id = BdfAtlasUtils.getIdFromTermCode(code);
        Motcle motcle = this.bdfAtlas.getMotcle(codeType, id);
        if (motcle == null) {
            this.addCodeError("_ error.unknown.fr-exemole-desmoservice.code", code, position);
            return null;
        }
        return motcle;
    }

    private int getAvailableId(String prefix) {
        if (this.availableIdMap.containsKey(prefix)) {
            return this.availableIdMap.get(prefix);
        }
        return 1;
    }

    private void setAvailableId(String prefix, int id) {
        this.availableIdMap.put(prefix, id);
    }

    private void addCodeError(String key, Object ... values) {
        this.messageHandler.addMessage("severe.code", LocalisationUtils.toMessage((String)key, (Object[])values));
    }
}

