/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.dsmd.dom;

import fr.exemole.bdfext.desmography.DesmographySpace;
import fr.exemole.bdfext.desmography.DsmSpace;
import fr.exemole.bdfext.desmography.dsmd.dom.MotcleMatcher;
import java.text.ParseException;
import net.fichotheque.thesaurus.Motcle;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeBuilder;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.attr.CheckedLocalKey;
import net.mapeadores.util.attr.CheckedNameSpace;
import net.mapeadores.util.text.CleanedString;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class AttributeDOMReader {
    private final CheckedLocalKey ROSETTE_DEFAULT = CheckedLocalKey.build((CharSequence)"rosette.default");
    private final MotcleMatcher motcleMatcher;

    private AttributeDOMReader(MotcleMatcher motcleMatcher) {
        this.motcleMatcher = motcleMatcher;
    }

    public static void read(MotcleMatcher motcleMatcher, Object attributeHolder, Element element) {
        new AttributeDOMReader(motcleMatcher).read(attributeHolder, element);
    }

    private void read(Object attributeHolder, Element element) {
        AttributeKey attributeKey = this.getAttributeKey(element);
        if (attributeKey == null) {
            return;
        }
        Attribute attribute = this.toAttribute(element, attributeKey);
        if (attribute != null) {
            this.motcleMatcher.getFichothequeEditor().putAttribute(attributeHolder, attribute);
        }
    }

    private Attribute toAttribute(Element element, AttributeKey attributeKey) {
        AttributeBuilder attributeBuilder = new AttributeBuilder(attributeKey);
        DOMUtils.readChildren((Element)element, child -> {
            String tagName = child.getTagName();
            if (tagName.equals("val")) {
                CleanedString cs = XMLUtils.toCleanedString((Element)child);
                if ((cs = this.checkValue(attributeKey, cs)) != null) {
                    attributeBuilder.addValue(cs);
                }
            }
        });
        return attributeBuilder.toAttribute();
    }

    private AttributeKey getAttributeKey(Element element) {
        CheckedLocalKey localKey;
        CheckedNameSpace nameSpace;
        String nameSpaceString = element.getAttribute("ns");
        if (nameSpaceString.length() == 0) {
            return null;
        }
        String localKeyString = element.getAttribute("key");
        if (localKeyString.length() == 0) {
            return null;
        }
        if (nameSpaceString.equals("atlas")) {
            nameSpace = DsmSpace.NAMESPACE;
        } else {
            try {
                nameSpace = CheckedNameSpace.parse((CharSequence)nameSpaceString);
            }
            catch (ParseException pe) {
                return null;
            }
        }
        switch (localKeyString) {
            case "ventilationnaturelle": {
                return DesmographySpace.ROSETTE_DEFAULT_KEY;
            }
        }
        try {
            localKey = CheckedLocalKey.parse((CharSequence)localKeyString);
        }
        catch (ParseException pe) {
            return null;
        }
        return AttributeKey.build((CheckedNameSpace)nameSpace, (CheckedLocalKey)localKey);
    }

    private CleanedString checkValue(AttributeKey attributeKey, CleanedString cs) {
        if (cs == null) {
            return null;
        }
        if (attributeKey.equals((Object)DesmographySpace.ROSETTE_DEFAULT_KEY)) {
            return this.checkVentilationValue(cs);
        }
        return cs;
    }

    private CleanedString checkVentilationValue(CleanedString cs) {
        String val = cs.toString();
        if (val.startsWith("ventilation:grille:")) {
            String grilleName = val.substring("ventilation:grille:".length());
            Motcle grille = this.motcleMatcher.matchGrille(grilleName, false);
            if (grille != null) {
                return CleanedString.newInstance((CharSequence)("grid:" + grille.getId()));
            }
            return null;
        }
        if (val.startsWith("ventilation:famille:")) {
            String familleId = val.substring("ventilation:famille:".length());
            Motcle famille = this.motcleMatcher.matchFamille(familleId, false);
            if (famille != null) {
                return CleanedString.newInstance((CharSequence)("family:" + famille.getId()));
            }
            return null;
        }
        return cs;
    }
}

