/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.commands;

import fr.exemole.bdfext.desmography.Desmography;
import fr.exemole.bdfext.desmography.dsmd.DsmdImportEngine;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.io.IOException;
import java.text.ParseException;
import net.fichotheque.SubsetKey;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.FileValue;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.xml.DOMUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class DsmdImportCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "DsmdImport";
    public static final String COMMANDKEY = "_ DESMOGRAPHY-02";
    public static final String NAME_PARAMNAME = "name";
    public static final String FILE_PARAMNAME = "file";
    private SubsetKey newThesaurusKey;

    public DsmdImportCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    public boolean needSynchronisation() {
        return true;
    }

    protected void doCommand() throws ErrorMessageException {
        Document document;
        FileValue fileValue = this.requestHandler.getRequestMap().getFileValue(FILE_PARAMNAME);
        if (fileValue == null) {
            throw BdfErrors.emptyMandatoryParameter((String)FILE_PARAMNAME);
        }
        if (fileValue.length() < 2L) {
            fileValue.free();
            throw BdfErrors.error((String)"_ error.empty.file");
        }
        try {
            document = DOMUtils.newDocumentBuilder().parse(fileValue.getInputStream());
        }
        catch (SAXException saxe) {
            throw BdfErrors.error((String)"_ error.exception.xml.sax", (Object[])new Object[]{saxe.getLocalizedMessage()});
        }
        catch (IOException ioe) {
            throw BdfErrors.ioException((IOException)ioe);
        }
        finally {
            fileValue.free();
        }
        try (EditSession session = this.startEditSession(Desmography.DOMAIN, COMMANDNAME);){
            DsmdImportEngine engine = new DsmdImportEngine(session.getFichothequeEditor(), session.getBdfServerEditor(), (BdfParameters)this.requestHandler);
            engine.run(this.newThesaurusKey, document);
        }
        this.setDone("_ done.desmography.dsmdimport", new Object[]{fileValue.getName(), this.newThesaurusKey.getSubsetName()});
    }

    protected void checkParameters() throws ErrorMessageException {
        String name = this.getMandatory(NAME_PARAMNAME).trim();
        if (name.length() == 0) {
            throw BdfErrors.error((String)"_ error.empty.thesaurusname");
        }
        try {
            this.newThesaurusKey = SubsetKey.parse((short)2, (String)name);
            if (this.fichotheque.containsSubset(this.newThesaurusKey)) {
                throw BdfErrors.error((String)"_ error.existing.thesaurus", (Object[])new Object[]{this.newThesaurusKey.getKeyString()});
            }
        }
        catch (ParseException pe) {
            throw BdfErrors.error((String)"_ error.wrong.thesaurusname", (Object[])new Object[]{name});
        }
    }
}

