/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.atlas.export;

import fr.exemole.bdfext.desmography.DesmographySpace;
import fr.exemole.bdfext.desmography.atlas.Atlas;
import fr.exemole.bdfext.desmography.atlas.AtlasUtils;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.junction.Junctions;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.attr.Attribute;
import net.scrutari.dataexport.api.RelationExport;
import net.scrutari.dataexport.api.ScrutariDataExport;

public final class ScrutariExportEngine {
    private final ScrutariDataExport scrutariDataExport;
    private final Atlas desmography;
    private final String thesaurusName;

    private ScrutariExportEngine(ScrutariDataExport scrutariDataExport, Atlas desmography) {
        this.scrutariDataExport = scrutariDataExport;
        this.desmography = desmography;
        this.thesaurusName = desmography.getTermThesaurus().getSubsetName();
    }

    public static void exportRelations(ScrutariDataExport scrutariDataExport, Atlas desmography) {
        ScrutariExportEngine engine = new ScrutariExportEngine(scrutariDataExport, desmography);
        ArrayList<FicheMeta> familyList = new ArrayList<FicheMeta>();
        ArrayList<FicheMeta> hierarchyList = new ArrayList<FicheMeta>();
        ArrayList<FicheMeta> subsectorsList = new ArrayList<FicheMeta>();
        ArrayList<FicheMeta> subfamiliesList = new ArrayList<FicheMeta>();
        for (FicheMeta relation : desmography.getRelationCorpus().getFicheMetaList()) {
            switch (AtlasUtils.getRelationType(relation)) {
                case "family": {
                    familyList.add(relation);
                    break;
                }
                case "hierarchy": {
                    hierarchyList.add(relation);
                    break;
                }
                case "subsectors": {
                    subsectorsList.add(relation);
                    break;
                }
                case "subfamilies": {
                    subfamiliesList.add(relation);
                }
            }
        }
        engine.exportSpecial(subsectorsList, subfamiliesList);
        engine.export("family", familyList, false);
        engine.export("hierarchy", hierarchyList, true);
    }

    private void exportSpecial(List<FicheMeta> subsectorsList, List<FicheMeta> subfamiliesList) {
        this.startRelations(null);
        List<Motcle> gridList = AtlasUtils.getGridsList(this.desmography);
        RelationExport relationExport = this.scrutariDataExport.newRelation("grids");
        relationExport.addMember("desmography", "thesaurus", this.thesaurusName);
        for (Motcle grid : gridList) {
            relationExport.addMember(null, null, String.valueOf(grid.getId()));
        }
        List<Motcle> rootFamilyList = AtlasUtils.getRootFamiliesList(this.desmography);
        relationExport = this.scrutariDataExport.newRelation("rootfamilies");
        relationExport.addMember("desmography", "thesaurus", this.thesaurusName);
        for (Motcle rootFamily : rootFamilyList) {
            relationExport.addMember(null, null, String.valueOf(rootFamily.getId()));
        }
        for (FicheMeta relation : subsectorsList) {
            relationExport = this.scrutariDataExport.newRelation("subsectors");
            this.addMember(relation, relationExport, false);
        }
        for (FicheMeta relation : subfamiliesList) {
            relationExport = this.scrutariDataExport.newRelation("subfamilies");
            this.addMember(relation, relationExport, false);
        }
        this.addHome();
        this.addRosetteDefault();
    }

    private void addHome() {
        Thesaurus termThesaurus = this.desmography.getTermThesaurus();
        Attribute attribute = termThesaurus.getThesaurusMetadata().getAttributes().getAttribute(DesmographySpace.HOME_KEY);
        if (attribute != null) {
            try {
                int id = Integer.parseInt(attribute.getFirstValue());
                Motcle motcle = termThesaurus.getMotcleById(id);
                if (motcle != null) {
                    RelationExport relationExport = this.scrutariDataExport.newRelation("home");
                    relationExport.addMember("desmography", "thesaurus", this.thesaurusName);
                    relationExport.addMember("root", null, String.valueOf(motcle.getId()));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void addRosetteDefault() {
        Thesaurus termThesaurus = this.desmography.getTermThesaurus();
        for (Motcle term : termThesaurus.getMotcleList()) {
            String firstValue;
            int idx;
            Attribute attribute = term.getAttributes().getAttribute(DesmographySpace.ROSETTE_DEFAULT_KEY);
            if (attribute == null || (idx = (firstValue = attribute.getFirstValue()).indexOf(":")) < 1) continue;
            String mode = firstValue.substring(0, idx);
            try {
                int id = Integer.parseInt(firstValue.substring(idx + 1));
                Motcle destination = termThesaurus.getMotcleById(id);
                if (destination == null) continue;
                RelationExport relationExport = this.scrutariDataExport.newRelation("rosette.default");
                relationExport.addMember("root", null, String.valueOf(term.getId()));
                relationExport.addMember(mode, null, String.valueOf(destination.getId()));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    private void addMember(FicheMeta relation, RelationExport relationExport, boolean withSector) {
        Junctions junctions = AtlasUtils.getTermJunctions(this.desmography, relation);
        for (Motcle term : AtlasUtils.getTermList(junctions, "superior")) {
            relationExport.addMember("superior", null, String.valueOf(term.getId()));
        }
        if (withSector) {
            for (Motcle term : AtlasUtils.getTermList(junctions, "sector")) {
                relationExport.addMember("sector", null, String.valueOf(term.getId()));
            }
        }
        for (Motcle term : AtlasUtils.getTermList(junctions, "inferior")) {
            relationExport.addMember(null, null, String.valueOf(term.getId()));
        }
    }

    private void export(String relationType, List<FicheMeta> list, boolean withSector) {
        this.startRelations(relationType);
        for (FicheMeta relation : list) {
            RelationExport relationExport = this.scrutariDataExport.newRelation(null);
            this.addMember(relation, relationExport, withSector);
        }
    }

    private void startRelations(String defaultRelationType) {
        this.scrutariDataExport.newRelations(defaultRelationType, "motcle", this.thesaurusName, null, "inferior");
    }
}

