/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography;

import fr.exemole.bdfext.desmography.DesmographyUtils;
import fr.exemole.bdfext.desmography.atlas.Atlas;
import fr.exemole.bdfext.desmography.producers.html.CreationHtmlProducer;
import fr.exemole.bdfext.desmography.producers.html.DashboardHtmlProducer;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.instruction.OutputParameters;
import fr.exemole.bdfserver.api.providers.HtmlProducerProvider;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.tools.instruction.BdfInstructionUtils;
import fr.exemole.bdfserver.tools.instruction.OutputRequestHandler;
import fr.exemole.bdfserver.tools.instruction.PermissionChecker;
import fr.exemole.bdfserver.tools.instruction.RequestHandler;
import java.text.ParseException;
import java.util.List;
import net.mapeadores.util.html.HtmlProducer;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.localisation.LangsUtils;
import net.mapeadores.util.logging.ErrorMessageException;

public class DesmographyHtmlProducerProvider
implements HtmlProducerProvider {
    public HtmlProducer getHtmlProducer(OutputParameters parameters) throws ErrorMessageException {
        BdfServerHtmlProducer htmlProducer = this.getBdfHtmlProducer(parameters);
        if (htmlProducer != null) {
            htmlProducer.setBdfCommandResult(parameters.getBdfCommandResult());
        }
        return htmlProducer;
    }

    private BdfServerHtmlProducer getBdfHtmlProducer(OutputParameters parameters) throws ErrorMessageException {
        String page;
        if (!BdfInstructionUtils.ownsToExtension((OutputParameters)parameters, (String)"desmography")) {
            return null;
        }
        OutputRequestHandler requestHandler = OutputRequestHandler.init((OutputParameters)parameters);
        PermissionChecker permissionChecker = requestHandler.getPermissionChecker();
        switch (page = parameters.getOutput()) {
            case "Creation": {
                permissionChecker.checkFichothequeAdmin();
                return new CreationHtmlProducer((BdfParameters)parameters);
            }
            case "Dashboard": {
                Atlas atlas = DesmographyUtils.getAtlas((RequestHandler)requestHandler);
                Lang lang = DesmographyHtmlProducerProvider.getLang(requestHandler, atlas);
                return new DashboardHtmlProducer((BdfParameters)parameters, atlas, lang);
            }
        }
        return null;
    }

    private static Lang getLang(OutputRequestHandler requestHandler, Atlas atlas) {
        Langs authorizedLangs;
        String langString = requestHandler.getTrimedParameter("lang");
        Lang lang = null;
        if (!langString.isEmpty()) {
            try {
                lang = Lang.parse((String)langString);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (lang == null) {
            lang = requestHandler.getWorkingLang();
        }
        if ((lang = LangsUtils.checkLang((Lang)lang, (List)(authorizedLangs = atlas.getLangs()))) != null) {
            return lang;
        }
        return (Lang)authorizedLangs.get(0);
    }
}

