/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.sync;

import fr.exemole.bdfext.desmography.sync.RelationSync;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.mapeadores.util.text.StringUtils;

public class RelationSyncBuilder {
    private final int id;
    private final String type;
    private final Map<String, Set<String>> idalphaMap = new HashMap<String, Set<String>>();

    public RelationSyncBuilder(int id, String type) {
        this.id = id;
        this.type = type;
    }

    public RelationSyncBuilder add(String mode, String idalpha) {
        Set<String> set = this.idalphaMap.get(mode);
        if (set == null) {
            set = new LinkedHashSet<String>();
            this.idalphaMap.put(mode, set);
        }
        set.add(idalpha);
        return this;
    }

    public RelationSync toRelationSync() {
        HashMap<String, List> finalIdalphaMap = new HashMap<String, List>();
        for (Map.Entry<String, Set<String>> entry : this.idalphaMap.entrySet()) {
            List finalList = StringUtils.toList((Collection)entry.getValue());
            finalIdalphaMap.put(entry.getKey(), finalList);
        }
        return new InternalRelationSync(this.id, this.type, finalIdalphaMap);
    }

    public static RelationSyncBuilder init(int id, String type) {
        return new RelationSyncBuilder(id, type);
    }

    private static class InternalRelationSync
    implements RelationSync {
        private final int id;
        private final String type;
        private final Map<String, List<String>> idalphaMap;

        private InternalRelationSync(int id, String type, Map<String, List<String>> idalphaMap) {
            this.id = id;
            this.type = type;
            this.idalphaMap = idalphaMap;
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public List<String> getIdalphaList(String mode) {
            List<String> list = this.idalphaMap.get(mode);
            if (list == null) {
                return StringUtils.EMPTY_STRINGLIST;
            }
            return list;
        }
    }
}

