/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.json;

import fr.exemole.bdfext.desmography.atlas.Atlas;
import fr.exemole.bdfext.desmography.atlas.AtlasUtils;
import fr.exemole.bdfext.desmography.json.Extract;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.junction.Junctions;
import net.fichotheque.junction.Liaison;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.utils.JunctionUtils;
import net.mapeadores.util.json.JSONWriter;

public final class RelationJson {
    private RelationJson() {
    }

    public static void properties(JSONWriter jw, Atlas atlas, Extract extract) throws IOException {
        jw.key("relations");
        jw.array();
        Iterator<FicheMeta> it = extract.getRelationIterator();
        while (it.hasNext()) {
            FicheMeta relation = it.next();
            jw.object();
            RelationJson.properties(jw, atlas, relation, extract);
            jw.endObject();
        }
        jw.endArray();
    }

    public static void properties(JSONWriter jw, Atlas atlas, FicheMeta relation, Extract extract) throws IOException {
        Junctions junctions = AtlasUtils.getTermJunctions(atlas, relation);
        SortedMap byModeMap = JunctionUtils.sortByMode((Junctions)junctions);
        jw.key("name").value((Object)String.valueOf(relation.getId()));
        jw.key("type").value((Object)AtlasUtils.getRelationType(relation));
        jw.key("roles");
        jw.object();
        for (Map.Entry entry : byModeMap.entrySet()) {
            String mode = (String)entry.getKey();
            Collection liaisons = (Collection)entry.getValue();
            jw.key(mode);
            jw.array();
            for (Liaison liaison : liaisons) {
                Motcle otherTerm = (Motcle)liaison.getSubsetItem();
                jw.value((Object)extract.addTerm(otherTerm));
            }
            jw.endArray();
        }
        jw.endObject();
    }
}

