/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.dsmd.dom;

import fr.exemole.bdfext.desmography.atlas.RelationEditor;
import fr.exemole.bdfext.desmography.dsmd.dom.MotcleMatcher;
import java.util.function.Consumer;
import net.fichotheque.thesaurus.Motcle;
import net.mapeadores.util.xml.DOMUtils;
import org.w3c.dom.Element;

public class StructureDOMReader {
    private StructureDOMReader() {
    }

    public static void createTerms(Element structureElement, MotcleMatcher motcleMatcher) {
        DOMUtils.readChildren((Element)structureElement, (Consumer)new TermCreationStep(motcleMatcher));
    }

    public static void populateTerms(Element structureElement, MotcleMatcher motcleMatcher) {
        DOMUtils.readChildren((Element)structureElement, (Consumer)new ContentStep(motcleMatcher));
    }

    public static void createRelations(Element structureElement, MotcleMatcher motcleMatcher, RelationEditor relationEditor) {
        DOMUtils.readChildren((Element)structureElement, (Consumer)new RelationCreationStep(motcleMatcher, relationEditor));
    }

    private static String getGrilleName(Element element) {
        String grilleName = element.getAttribute("name");
        if (grilleName.length() == 0) {
            grilleName = element.getAttribute("grl");
        }
        if (grilleName.length() == 0) {
            grilleName = element.getAttribute("nomgrille");
        }
        return grilleName;
    }

    private static class TermCreationStep
    implements Consumer<Element> {
        private final MotcleMatcher motcleMatcher;
        private final FamilleConsumer familleConsumer = new FamilleConsumer();

        private TermCreationStep(MotcleMatcher motcleMatcher) {
            this.motcleMatcher = motcleMatcher;
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("grille")) {
                String grilleName = StructureDOMReader.getGrilleName(element);
                if (grilleName.isEmpty()) {
                    return;
                }
                this.motcleMatcher.matchGrille(grilleName, true);
                DOMUtils.readChildren((Element)element, (Consumer)new ContexteConsumer(grilleName));
            } else if (tagName.equals("familles")) {
                DOMUtils.readChildren((Element)element, (Consumer)this.familleConsumer);
            }
        }

        private class FamilleConsumer
        implements Consumer<Element> {
            private FamilleConsumer() {
            }

            @Override
            public void accept(Element element) {
                String tagName = element.getTagName();
                if (tagName.equals("contexte")) {
                    String idctxt = element.getAttribute("idctxt");
                    if (idctxt.length() == 0) {
                        return;
                    }
                    Motcle contexte = TermCreationStep.this.motcleMatcher.matchFamille(idctxt, true);
                    DOMUtils.readChildren((Element)element, (Consumer)TermCreationStep.this.familleConsumer);
                }
            }
        }

        private class ContexteConsumer
        implements Consumer<Element> {
            private final String grilleName;

            private ContexteConsumer(String grilleName) {
                this.grilleName = grilleName;
            }

            @Override
            public void accept(Element element) {
                String tagName = element.getTagName();
                if (tagName.equals("contexte")) {
                    String idctxt = element.getAttribute("idctxt");
                    if (idctxt.length() == 0) {
                        return;
                    }
                    TermCreationStep.this.motcleMatcher.matchContexte(this.grilleName, idctxt, true);
                    DOMUtils.readChildren((Element)element, (Consumer)this);
                }
            }
        }
    }

    private static class ContentStep
    implements Consumer<Element> {
        private final MotcleMatcher motcleMatcher;
        private final FamilleConsumer familleConsumer = new FamilleConsumer();

        private ContentStep(MotcleMatcher motcleMatcher) {
            this.motcleMatcher = motcleMatcher;
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("grille")) {
                String grilleName = StructureDOMReader.getGrilleName(element);
                if (grilleName.isEmpty()) {
                    return;
                }
                Motcle grille = this.motcleMatcher.matchGrille(grilleName, false);
                if (grille != null) {
                    this.motcleMatcher.readTermContent(element, grille);
                    DOMUtils.readChildren((Element)element, (Consumer)new ContexteConsumer(grilleName));
                }
            } else if (tagName.equals("familles")) {
                DOMUtils.readChildren((Element)element, (Consumer)this.familleConsumer);
            }
        }

        private class FamilleConsumer
        implements Consumer<Element> {
            private FamilleConsumer() {
            }

            @Override
            public void accept(Element element) {
                String tagName = element.getTagName();
                if (tagName.equals("contexte")) {
                    String idctxt = element.getAttribute("idctxt");
                    if (idctxt.length() == 0) {
                        return;
                    }
                    Motcle contexte = ContentStep.this.motcleMatcher.matchFamille(idctxt, false);
                    if (contexte != null) {
                        ContentStep.this.motcleMatcher.readTermContent(element, contexte);
                        DOMUtils.readChildren((Element)element, (Consumer)ContentStep.this.familleConsumer);
                    }
                }
            }
        }

        private class ContexteConsumer
        implements Consumer<Element> {
            private final String grilleName;

            private ContexteConsumer(String grilleName) {
                this.grilleName = grilleName;
            }

            @Override
            public void accept(Element element) {
                String tagName = element.getTagName();
                if (tagName.equals("contexte")) {
                    String idctxt = element.getAttribute("idctxt");
                    if (idctxt.length() == 0) {
                        return;
                    }
                    Motcle contexte = ContentStep.this.motcleMatcher.matchContexte(this.grilleName, idctxt, false);
                    if (contexte != null) {
                        ContentStep.this.motcleMatcher.readTermContent(element, contexte);
                        DOMUtils.readChildren((Element)element, (Consumer)this);
                    }
                }
            }
        }
    }

    private static class RelationCreationStep
    implements Consumer<Element> {
        private final MotcleMatcher motcleMatcher;
        private final RelationEditor relationEditor;

        private RelationCreationStep(MotcleMatcher motcleMatcher, RelationEditor relationEditor) {
            this.motcleMatcher = motcleMatcher;
            this.relationEditor = relationEditor;
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("grille")) {
                String grilleName = StructureDOMReader.getGrilleName(element);
                if (grilleName.isEmpty()) {
                    return;
                }
                Motcle grille = this.motcleMatcher.matchGrille(grilleName, false);
                DOMUtils.readChildren((Element)element, (Consumer)new ContexteConsumer(grilleName, grille));
            } else if (tagName.equals("familles")) {
                DOMUtils.readChildren((Element)element, (Consumer)new FamilleConsumer(null));
            }
        }

        private class ContexteConsumer
        implements Consumer<Element> {
            private final String grilleName;
            private final Motcle parent;

            private ContexteConsumer(String grilleName, Motcle parent) {
                this.grilleName = grilleName;
                this.parent = parent;
            }

            @Override
            public void accept(Element element) {
                String tagName = element.getTagName();
                if (tagName.equals("contexte")) {
                    String idctxt = element.getAttribute("idctxt");
                    if (idctxt.length() == 0) {
                        return;
                    }
                    Motcle contexte = RelationCreationStep.this.motcleMatcher.matchContexte(this.grilleName, idctxt, false);
                    if (contexte == null) {
                        return;
                    }
                    RelationCreationStep.this.relationEditor.addSubsector(this.parent, contexte);
                    DOMUtils.readChildren((Element)element, (Consumer)new ContexteConsumer(this.grilleName, contexte));
                }
            }
        }

        private class FamilleConsumer
        implements Consumer<Element> {
            private final Motcle parent;

            private FamilleConsumer(Motcle parent) {
                this.parent = parent;
            }

            @Override
            public void accept(Element element) {
                String tagName = element.getTagName();
                if (tagName.equals("contexte")) {
                    String idctxt = element.getAttribute("idctxt");
                    if (idctxt.length() == 0) {
                        return;
                    }
                    Motcle contexte = RelationCreationStep.this.motcleMatcher.matchFamille(idctxt, false);
                    if (contexte == null) {
                        return;
                    }
                    if (this.parent == null) {
                        RelationCreationStep.this.relationEditor.addRootFamily(contexte);
                    } else {
                        RelationCreationStep.this.relationEditor.addSubfamily(this.parent, contexte);
                    }
                }
            }
        }
    }
}

