/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.atlas;

import fr.exemole.bdfext.desmography.atlas.Atlas;
import fr.exemole.bdfext.desmography.atlas.AtlasUtils;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.thesaurus.Motcle;

public final class RelationTrace {
    private static final int[] EMPTY_ARRAY = new int[0];
    private final String type;
    private final int[] idArray;

    private RelationTrace(String type, int[] idArray) {
        this.type = type;
        this.idArray = idArray;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        RelationTrace otherTrace = (RelationTrace)other;
        if (!otherTrace.type.equals(this.type)) {
            return false;
        }
        return RelationTrace.areEqual(this.idArray, otherTrace.idArray);
    }

    public int hashCode() {
        return Arrays.hashCode(this.idArray);
    }

    public static RelationTrace traceSuperiors(Atlas atlas, FicheMeta relation) {
        int[] idArray = RelationTrace.toIdArray(AtlasUtils.superiors(atlas, relation));
        return new RelationTrace(AtlasUtils.getRelationType(relation), idArray);
    }

    private static boolean areEqual(int[] array1, int[] array2) {
        int length = array1.length;
        if (array2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    private static int[] toIdArray(List<Motcle> motcleList) {
        int size = motcleList.size();
        switch (size) {
            case 0: {
                return EMPTY_ARRAY;
            }
            case 1: {
                int[] result1 = new int[]{motcleList.get(0).getId()};
                return result1;
            }
        }
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (Motcle motcle : motcleList) {
            set.add(motcle.getId());
        }
        int[] result = new int[size];
        int p = 0;
        for (Integer itg : set) {
            result[p] = itg;
            ++p;
        }
        return result;
    }
}

