/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.xml.api;

import java.util.Set;
import java.util.function.Consumer;
import net.desmodo.atlas.AtlasEditor;
import net.desmodo.atlas.AtlasUtils;
import net.desmodo.atlas.xml.api.AtlasDOMErrorHandler;
import net.desmodo.atlas.xml.api.DescripteursDOMReader;
import net.desmodo.atlas.xml.api.LiensDOMReader;
import net.desmodo.atlas.xml.api.MetadataDOMReader;
import net.desmodo.atlas.xml.api.StructureDOMReader;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangsUtils;
import net.mapeadores.util.xml.DOMUtils;
import org.w3c.dom.Element;

public class AtlasDOMReader {
    private final AtlasDOMErrorHandler errorHandler;
    private final AtlasEditor atlasEditor;
    private String xpath;

    public AtlasDOMReader(AtlasEditor atlasEditor, AtlasDOMErrorHandler errorHandler) {
        this.atlasEditor = atlasEditor;
        this.errorHandler = errorHandler;
    }

    public void readAtlasElement(Element element, String xpath) {
        Set<Lang> set;
        this.xpath = xpath;
        AtlasConsumer atlasConsumer = new AtlasConsumer();
        DOMUtils.readChildren((Element)element, (Consumer)atlasConsumer);
        if (!atlasConsumer.isWithLang() && !(set = AtlasUtils.getUsedLangSet(this.atlasEditor.getAtlas())).isEmpty()) {
            this.atlasEditor.getAtlasMetaDataEditor().setWorkingLangs(LangsUtils.fromCollection(set));
        }
    }

    private class AtlasConsumer
    implements Consumer<Element> {
        private boolean withLang = false;

        private AtlasConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("metadata")) {
                MetadataDOMReader metadataDOMReader = new MetadataDOMReader(AtlasDOMReader.this.atlasEditor, AtlasDOMReader.this.errorHandler);
                metadataDOMReader.readMetadataElement(element, AtlasDOMReader.this.xpath + "/metadata");
                if (!this.withLang) {
                    this.withLang = metadataDOMReader.isWithLang();
                }
            } else if (tagName.equals("structure")) {
                StructureDOMReader structureDOMReader = new StructureDOMReader(AtlasDOMReader.this.atlasEditor, AtlasDOMReader.this.errorHandler);
                structureDOMReader.readStructureElement(element, AtlasDOMReader.this.xpath + "/structure");
            } else if (tagName.equals("descripteurs")) {
                DescripteursDOMReader descripteursDOMReader = new DescripteursDOMReader(AtlasDOMReader.this.atlasEditor, AtlasDOMReader.this.errorHandler);
                descripteursDOMReader.readDescripteursElement(element, AtlasDOMReader.this.xpath + "/descripteurs");
            } else if (tagName.equals("liens")) {
                LiensDOMReader liensDOMReader = new LiensDOMReader(AtlasDOMReader.this.atlasEditor.getLiensEditor(), AtlasDOMReader.this.errorHandler);
                liensDOMReader.readLiensElement(element, AtlasDOMReader.this.xpath + "/liens");
            } else {
                AtlasDOMReader.this.errorHandler.unknownTagWarning(tagName, AtlasDOMReader.this.xpath);
            }
        }

        private boolean isWithLang() {
            return this.withLang;
        }
    }
}

