/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.sxio;

import java.awt.Point;
import java.io.IOException;
import net.mapeadores.util.date.FuzzyDate;
import net.mapeadores.util.xml.XMLUtils;

public class SXUtils {
    private SXUtils() {
    }

    public static void writeArc(Appendable appendable, int x, int y, int width, int height, int startAngle, int arcAngle, String layerName, String styleName) throws IOException {
        appendable.append("<draw:ellipse draw:kind='arc' draw:style-name='");
        appendable.append(styleName);
        appendable.append('\'');
        appendable.append(" draw:layer='");
        appendable.append(layerName);
        appendable.append('\'');
        appendable.append(" svg:width='");
        appendable.append(String.valueOf(width));
        appendable.append("pt'");
        appendable.append(" svg:height='");
        appendable.append(String.valueOf(height));
        appendable.append("pt'");
        appendable.append(" svg:x='");
        appendable.append(String.valueOf(x));
        appendable.append("pt'");
        appendable.append(" svg:y='");
        appendable.append(String.valueOf(y));
        appendable.append("pt'");
        appendable.append(" draw:start-angle='");
        appendable.append(String.valueOf(startAngle));
        appendable.append('\'');
        appendable.append(" draw:end-angle='");
        appendable.append(String.valueOf(arcAngle + startAngle));
        appendable.append('\'');
        appendable.append("/>");
    }

    public static void writeLine(Appendable appendable, Point A, Point B, String layerName, String styleName) throws IOException {
        appendable.append("<draw:line draw:style-name='");
        appendable.append(styleName);
        appendable.append('\'');
        appendable.append(" draw:layer='");
        appendable.append(layerName);
        appendable.append('\'');
        appendable.append(" svg:x1='");
        appendable.append(String.valueOf(A.x));
        appendable.append("pt'");
        appendable.append(" svg:y1='");
        appendable.append(String.valueOf(A.y));
        appendable.append("pt'");
        appendable.append(" svg:x2='");
        appendable.append(String.valueOf(B.x));
        appendable.append("pt'");
        appendable.append(" svg:y2='");
        appendable.append(String.valueOf(B.y));
        appendable.append("pt'");
        appendable.append("/>");
    }

    public static void writeEmptyCell(Appendable appendable) throws IOException {
        SXUtils.startCell(appendable);
        SXUtils.endCell(appendable);
    }

    public static void writeIntCell(Appendable appendable, int value) throws IOException {
        appendable.append("<table:table-cell table:value-type=\"float\" table:value=\"");
        appendable.append(String.valueOf(value));
        appendable.append("\">");
        SXUtils.writeP(appendable, String.valueOf(value));
        SXUtils.endCell(appendable);
    }

    public static void writeBooleanCell(Appendable appendable, boolean value) throws IOException {
        int val = value ? 1 : 0;
        SXUtils.writeIntCell(appendable, val);
    }

    public static void writeStringCell(Appendable appendable, String s) throws IOException {
        SXUtils.startCell(appendable);
        SXUtils.writeP(appendable, s);
        SXUtils.endCell(appendable);
    }

    public static void startCell(Appendable appendable) throws IOException {
        appendable.append("<table:table-cell>");
    }

    public static void endCell(Appendable appendable) throws IOException {
        appendable.append("</table:table-cell>");
    }

    public static void startP(Appendable appendable) throws IOException {
        appendable.append("<text:p>");
    }

    public static void endP(Appendable appendable) throws IOException {
        appendable.append("</text:p>");
    }

    public static void writeP(Appendable appendable, String s) throws IOException {
        appendable.append("<text:p>");
        if (s != null) {
            XMLUtils.writeEscape((Appendable)appendable, (String)s);
        }
        appendable.append("</text:p>");
    }

    public static void writeDate(Appendable appendable, FuzzyDate date) throws IOException {
        SXUtils.writeDate(appendable, date.toISOString());
    }

    public static void writeDate(Appendable appendable, String isoString) throws IOException {
        appendable.append("<table:table-cell table:value-type=\"date\" table:style-name=\"c0\" table:date-value=\"");
        appendable.append(isoString);
        appendable.append("\">");
        appendable.append(isoString);
        appendable.append("</table:table-cell>");
    }

    public static void writeSpace(Appendable appendable, int number) throws IOException {
        appendable.append("<text:s text:c=\"");
        appendable.append(String.valueOf(number));
        appendable.append("\"/>");
    }

    public static void startGroup(Appendable appendable) {
    }
}

