/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.impl;

import java.util.HashMap;
import java.util.Map;
import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.descripteurs.DescripteurList;
import net.desmodo.atlas.descripteurs.Descripteurs;
import net.desmodo.atlas.descripteurs.DescripteursEditor;
import net.desmodo.atlas.descripteurs.DescripteursUtils;
import net.desmodo.atlas.descripteurs.ExistingIddescException;
import net.desmodo.atlas.descripteurs.Iddesc;
import net.desmodo.atlas.descripteurs.UnremovableDescripteurException;
import net.desmodo.atlas.event.DescripteurEvent;
import net.desmodo.atlas.event.DescripteursListener;
import net.desmodo.atlas.impl.TermCoder;
import net.desmodo.atlas.impl.TermImpl;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.structure.InvalidContexteException;
import net.desmodo.atlas.structure.StructureUtils;
import net.mapeadores.util.misc.ArrayUtils;

class DescripteursImpl
implements Descripteurs {
    private final Map<Iddesc, Descripteur> descripteurMap = new HashMap<Iddesc, Descripteur>();
    private final Map<String, SubsetName> subsetNameMap = new HashMap<String, SubsetName>();
    private final SubsetName defaultSubsetName = new SubsetName("");
    private final Atlas atlas;
    private final TermCoder termCoder;
    private final Map<Integer, FamilleList> familleMap = new HashMap<Integer, FamilleList>();
    private final Contexte sansfamilleContexte;
    private final FamilleList sansfamilleList;
    private DescripteursListener[] descripteursListeners = new DescripteursListener[0];
    private final DescripteursEditor descripteursEditor = new DescripteursEditorImpl();

    DescripteursImpl(Atlas atlas, TermCoder termCoder) {
        this.atlas = atlas;
        this.termCoder = termCoder;
        this.sansfamilleContexte = StructureUtils.getSansfamilleContexte(atlas.getStructure());
        this.sansfamilleList = new FamilleList();
        this.familleMap.put(this.sansfamilleContexte.getCode(), this.sansfamilleList);
    }

    @Override
    public Atlas getAtlas() {
        return this.atlas;
    }

    @Override
    public void addDescripteursListener(DescripteursListener descripteursListener) {
        this.descripteursListeners = (DescripteursListener[])ArrayUtils.addUnique((Object[])this.descripteursListeners, (Object)descripteursListener, (Object[])new DescripteursListener[this.descripteursListeners.length + 1]);
    }

    @Override
    public void removeDescripteursListener(DescripteursListener descripteursListener) {
        if (this.descripteursListeners.length > 0) {
            this.descripteursListeners = (DescripteursListener[])ArrayUtils.removeUnique((Object[])this.descripteursListeners, (Object)descripteursListener, (Object[])new DescripteursListener[this.descripteursListeners.length - 1]);
        }
    }

    @Override
    public Descripteur getDescripteurByIddesc(Iddesc iddesc) {
        return this.descripteurMap.get(iddesc);
    }

    @Override
    public DescripteurList getInFamilleDescripteurList(Contexte famille) {
        DescripteurList liste = this.familleMap.get(famille.getCode());
        if (liste == null) {
            return DescripteursUtils.EMPTY_DESCRIPTEUR_LIST;
        }
        return liste;
    }

    DescripteursEditor getDescripteursEditor() {
        return this.descripteursEditor;
    }

    void fireFamilleChanged(Descripteur descripteur, Contexte oldFamille) {
        int length = this.descripteursListeners.length;
        if (length == 0) {
            return;
        }
        DescripteurEvent descripteurEvent = new DescripteurEvent(descripteur, oldFamille);
        for (int i = 0; i < length; ++i) {
            this.descripteursListeners[i].familleChanged(descripteurEvent);
        }
    }

    void fireDescripteurCreated(Descripteur descripteur) {
        int length = this.descripteursListeners.length;
        if (length == 0) {
            return;
        }
        DescripteurEvent descripteurEvent = new DescripteurEvent(descripteur);
        for (int i = 0; i < length; ++i) {
            this.descripteursListeners[i].descripteurCreated(descripteurEvent);
        }
    }

    void fireDescripteurRemoved(Descripteur descripteur, Contexte oldFamille) {
        int length = this.descripteursListeners.length;
        if (length == 0) {
            return;
        }
        DescripteurEvent descripteurEvent = new DescripteurEvent(descripteur, oldFamille);
        for (int i = 0; i < length; ++i) {
            this.descripteursListeners[i].descripteurRemoved(descripteurEvent);
        }
    }

    private DescripteurImpl testDescripteur(Descripteur descripteur, String argument) throws IllegalArgumentException {
        try {
            DescripteurImpl defdescripteur = (DescripteurImpl)descripteur;
            if (defdescripteur.getDescripteurs() != this) {
                throw new IllegalArgumentException(argument + " argument does not come from this descripteurs");
            }
            return defdescripteur;
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException(argument + " argument does not come from this descripteurs");
        }
    }

    private void testFamille(Contexte contexte, String argument) throws IllegalArgumentException, InvalidContexteException {
        if (!StructureUtils.isFamilleOrSansfamille(contexte)) {
            throw new InvalidContexteException();
        }
        if (!contexte.isActive()) {
            throw new InvalidContexteException("Famille is not active");
        }
        if (contexte.getAtlas() != this.atlas) {
            throw new IllegalArgumentException(argument + " argument does not come from this atlas");
        }
    }

    private Iddesc getIddesc(String stringPart, int intPart) {
        SubsetName subsetName;
        if (intPart == -1) {
            Iddesc iddesc = Iddesc.parse(stringPart);
            if (iddesc.hasIntPart()) {
                stringPart = iddesc.getStringPart();
                intPart = iddesc.getIntPart();
            } else {
                return iddesc;
            }
        }
        if (stringPart.length() == 0) {
            subsetName = this.defaultSubsetName;
        } else {
            subsetName = this.subsetNameMap.get(stringPart);
            if (subsetName == null) {
                subsetName = new SubsetName(stringPart);
                this.subsetNameMap.put(stringPart, subsetName);
            }
        }
        return subsetName.getIddesc(intPart);
    }

    private class DescripteurImpl
    extends TermImpl
    implements Descripteur {
        private Contexte famille;
        private final Iddesc iddesc;
        private FamilleList familleList;

        DescripteurImpl(int code, Iddesc iddesc) {
            super(code);
            this.iddesc = iddesc;
        }

        @Override
        public Atlas getAtlas() {
            return DescripteursImpl.this.atlas;
        }

        @Override
        public Descripteurs getDescripteurs() {
            return DescripteursImpl.this;
        }

        @Override
        public Contexte getFamille() {
            return this.famille;
        }

        @Override
        public Iddesc getIddesc() {
            return this.iddesc;
        }

        @Override
        public short getTermType() {
            return 1;
        }
    }

    private static class FamilleList
    implements DescripteurList {
        private DescripteurImpl[] descripteurs = new DescripteurImpl[16];
        private int size = 0;

        private FamilleList() {
        }

        private void removeDescripteur(DescripteurImpl defdesc) {
            int i;
            int index = -1;
            for (i = 0; i < this.size; ++i) {
                if (!this.descripteurs[i].equals(defdesc)) continue;
                index = i;
                break;
            }
            if (index == -1) {
                return;
            }
            for (i = index; i < this.size - 1; ++i) {
                DescripteurImpl d;
                this.descripteurs[i] = d = this.descripteurs[i + 1];
            }
            --this.size;
            this.descripteurs[this.size] = null;
            defdesc.familleList = null;
        }

        private void addDescripteur(DescripteurImpl defdesc) {
            if (this.descripteurs.length == this.size) {
                DescripteurImpl[] nv = new DescripteurImpl[this.size * 2];
                System.arraycopy(this.descripteurs, 0, nv, 0, this.size);
                this.descripteurs = nv;
            }
            defdesc.familleList = this;
            this.descripteurs[this.size] = defdesc;
            ++this.size;
        }

        @Override
        public Descripteur getDescripteur(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException();
            }
            return this.descripteurs[index];
        }

        @Override
        public int getDescripteurCount() {
            return this.size;
        }
    }

    private static class SubsetName {
        private final String stringPart;
        private int availableIntpart = 1;

        private SubsetName(String stringPart) {
            this.stringPart = stringPart;
        }

        private void updateAvailableIntPart(int number) {
            this.availableIntpart = Math.max(this.availableIntpart, number + 1);
        }

        private Iddesc getIddesc(int intPart) {
            Iddesc iddesc;
            if (intPart == -2) {
                iddesc = new Iddesc(this.stringPart, this.availableIntpart);
                ++this.availableIntpart;
            } else {
                iddesc = new Iddesc(this.stringPart, intPart);
                this.updateAvailableIntPart(intPart);
            }
            return iddesc;
        }
    }

    private class DescripteursEditorImpl
    implements DescripteursEditor {
        DescripteursEditorImpl() {
        }

        @Override
        public Descripteur createDescripteur(String stringPart, int intPart) throws ExistingIddescException {
            if (stringPart == null) {
                stringPart = "";
            }
            Iddesc iddesc = DescripteursImpl.this.getIddesc(stringPart, intPart);
            if (DescripteursImpl.this.descripteurMap.containsKey(iddesc)) {
                throw new ExistingIddescException(iddesc);
            }
            int newCode = DescripteursImpl.this.termCoder.getNewCode();
            DescripteurImpl defdesc = new DescripteurImpl(newCode, iddesc);
            defdesc.famille = DescripteursImpl.this.sansfamilleContexte;
            DescripteursImpl.this.sansfamilleList.addDescripteur(defdesc);
            DescripteursImpl.this.descripteurMap.put(iddesc, defdesc);
            DescripteursImpl.this.termCoder.setTerm(newCode, defdesc);
            DescripteursImpl.this.fireDescripteurCreated(defdesc);
            return defdesc;
        }

        @Override
        public void removeDescripteur(Descripteur descripteur) throws UnremovableDescripteurException {
            DescripteurImpl defaultDescripteur = DescripteursImpl.this.testDescripteur(descripteur, "descripteur");
            if (DescripteursImpl.this.atlas.getLiens().getLienCount(descripteur) > 0) {
                throw new UnremovableDescripteurException();
            }
            DescripteursImpl.this.termCoder.setTerm(defaultDescripteur.getCode(), null);
            Contexte oldFamille = defaultDescripteur.famille;
            defaultDescripteur.familleList.removeDescripteur(defaultDescripteur);
            defaultDescripteur.familleList = null;
            defaultDescripteur.famille = null;
            DescripteursImpl.this.descripteurMap.remove(defaultDescripteur.getIddesc());
            DescripteursImpl.this.fireDescripteurRemoved(defaultDescripteur, oldFamille);
        }

        @Override
        public Descripteurs getDescripteurs() {
            return DescripteursImpl.this;
        }

        @Override
        public boolean setFamille(Descripteur descripteur, Contexte famille) throws InvalidContexteException {
            if (famille != null) {
                DescripteursImpl.this.testFamille(famille, "famille");
            } else {
                famille = StructureUtils.getSansfamilleContexte(DescripteursImpl.this.atlas.getStructure());
            }
            DescripteurImpl defdesc = DescripteursImpl.this.testDescripteur(descripteur, "descripteur");
            Contexte oldFamille = defdesc.famille;
            if (oldFamille.equals(famille)) {
                return false;
            }
            defdesc.familleList.removeDescripteur(defdesc);
            FamilleList familleList = (FamilleList)DescripteursImpl.this.familleMap.get(famille.getCode());
            if (familleList == null) {
                familleList = new FamilleList();
                DescripteursImpl.this.familleMap.put(famille.getCode(), familleList);
            }
            familleList.addDescripteur(defdesc);
            defdesc.famille = famille;
            DescripteursImpl.this.fireFamilleChanged(defdesc, oldFamille);
            return true;
        }
    }
}

