/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.impl;

import java.util.ConcurrentModificationException;
import java.util.EventObject;
import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.AtlasEditor;
import net.desmodo.atlas.Term;
import net.desmodo.atlas.descripteurs.Descripteurs;
import net.desmodo.atlas.descripteurs.DescripteursEditor;
import net.desmodo.atlas.event.AttributeEvent;
import net.desmodo.atlas.event.AttributeListener;
import net.desmodo.atlas.event.CompoundAtlasEvent;
import net.desmodo.atlas.event.CompoundAtlasEventListener;
import net.desmodo.atlas.event.LabelEvent;
import net.desmodo.atlas.event.LabelListener;
import net.desmodo.atlas.impl.AtlasMetadataImpl;
import net.desmodo.atlas.impl.DescripteursImpl;
import net.desmodo.atlas.impl.LiensImpl;
import net.desmodo.atlas.impl.StructureImpl;
import net.desmodo.atlas.impl.TermCoder;
import net.desmodo.atlas.impl.TermImpl;
import net.desmodo.atlas.l10n.AtlasL10n;
import net.desmodo.atlas.liens.Liens;
import net.desmodo.atlas.liens.LiensEditor;
import net.desmodo.atlas.metadata.AtlasMetadata;
import net.desmodo.atlas.metadata.AtlasMetadataEditor;
import net.desmodo.atlas.structure.Structure;
import net.desmodo.atlas.structure.StructureEditor;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.misc.ArrayUtils;
import net.mapeadores.util.text.Label;

class AtlasImpl
implements Atlas {
    private final TermCoder termCoder = new TermCoder();
    private final AtlasMetadataImpl metadata;
    private final StructureImpl structure;
    private final AtlasEditorImpl atlasEditor = new AtlasEditorImpl();
    private final DescripteursImpl descripteurs;
    private final LiensImpl liens;
    private CompoundAtlasEventListener[] compoundAtlasEventListeners = new CompoundAtlasEventListener[0];
    private AttributeListener[] attributeListeners = new AttributeListener[0];
    private LabelListener[] libelleListeners = new LabelListener[0];

    AtlasImpl() {
        this.metadata = new AtlasMetadataImpl(this, this.termCoder);
        this.structure = new StructureImpl(this, this.termCoder);
        this.structure.setSpecialContexteLibs((short)5, AtlasL10n.getSpecialTypeLabels((short)5));
        this.structure.setSpecialContexteLibs((short)6, AtlasL10n.getSpecialTypeLabels((short)6));
        this.structure.setGrilledesfamillesLibs(AtlasL10n.getSpecialTypeLabels((short)7));
        this.descripteurs = new DescripteursImpl(this, this.termCoder);
        this.liens = new LiensImpl(this);
    }

    @Override
    public AtlasMetadata getAtlasMetadata() {
        return this.metadata;
    }

    @Override
    public Descripteurs getDescripteurs() {
        return this.descripteurs;
    }

    @Override
    public Liens getLiens() {
        return this.liens;
    }

    @Override
    public Structure getStructure() {
        return this.structure;
    }

    @Override
    public Term getTerm(int code) {
        return this.termCoder.getTerm(code);
    }

    @Override
    public void addCompoundAtlasEventListener(CompoundAtlasEventListener compoundAtlasEventListener) {
        this.compoundAtlasEventListeners = (CompoundAtlasEventListener[])ArrayUtils.addUnique((Object[])this.compoundAtlasEventListeners, (Object)compoundAtlasEventListener, (Object[])new CompoundAtlasEventListener[this.compoundAtlasEventListeners.length + 1]);
    }

    @Override
    public void removeCompoundAtlasEventListener(CompoundAtlasEventListener compoundAtlasEventListener) {
        if (this.compoundAtlasEventListeners.length > 0) {
            this.compoundAtlasEventListeners = (CompoundAtlasEventListener[])ArrayUtils.removeUnique((Object[])this.compoundAtlasEventListeners, (Object)compoundAtlasEventListener, (Object[])new CompoundAtlasEventListener[this.compoundAtlasEventListeners.length - 1]);
        }
    }

    @Override
    public void addAttributeListener(AttributeListener attributeListener) {
        this.attributeListeners = (AttributeListener[])ArrayUtils.addUnique((Object[])this.attributeListeners, (Object)attributeListener, (Object[])new AttributeListener[this.attributeListeners.length + 1]);
    }

    @Override
    public void removeAttributeListener(AttributeListener attributeListener) {
        if (this.attributeListeners.length > 0) {
            this.attributeListeners = (AttributeListener[])ArrayUtils.removeUnique((Object[])this.attributeListeners, (Object)attributeListener, (Object[])new AttributeListener[this.attributeListeners.length - 1]);
        }
    }

    @Override
    public void addLibelleListener(LabelListener libelleListener) {
        this.libelleListeners = (LabelListener[])ArrayUtils.addUnique((Object[])this.libelleListeners, (Object)libelleListener, (Object[])new LabelListener[this.libelleListeners.length + 1]);
    }

    @Override
    public void removeLibelleListener(LabelListener libelleListener) {
        if (this.libelleListeners.length > 0) {
            this.libelleListeners = (LabelListener[])ArrayUtils.removeUnique((Object[])this.libelleListeners, (Object)libelleListener, (Object[])new LabelListener[this.libelleListeners.length - 1]);
        }
    }

    AtlasEditorImpl getAtlasEditor() {
        return this.atlasEditor;
    }

    void fireAttributeRemoved(Object attributesHolder, Attribute oldAttribute) {
        int length = this.attributeListeners.length;
        if (length == 0) {
            return;
        }
        AttributeEvent attributeEvent = new AttributeEvent(this, attributesHolder, oldAttribute.getAttributeKey(), oldAttribute);
        for (int i = 0; i < length; ++i) {
            this.attributeListeners[i].attributeRemoved(attributeEvent);
        }
    }

    void fireAttributeChanged(Object attributesHolder, AttributeKey attributeKey, Attribute oldAttribute) {
        int length = this.attributeListeners.length;
        if (length == 0) {
            return;
        }
        AttributeEvent attributeEvent = new AttributeEvent(this, attributesHolder, attributeKey, oldAttribute);
        for (int i = 0; i < length; ++i) {
            this.attributeListeners[i].attributeChanged(attributeEvent);
        }
    }

    void fireLabelRemoved(Object labelHolder) {
        int length = this.libelleListeners.length;
        if (length == 0) {
            return;
        }
        LabelEvent libelleEvent = new LabelEvent(this, labelHolder);
        for (int i = 0; i < length; ++i) {
            this.libelleListeners[i].labelRemoved(libelleEvent);
        }
    }

    void fireLabelChanged(Object labelHolder) {
        int length = this.libelleListeners.length;
        if (length == 0) {
            return;
        }
        LabelEvent libelleEvent = new LabelEvent(this, labelHolder);
        for (int i = 0; i < length; ++i) {
            this.libelleListeners[i].labelChanged(libelleEvent);
        }
    }

    private class AtlasEditorImpl
    implements AtlasEditor {
        private boolean compoundEventProcessed = false;
        private Object currentSource;
        private String currentName;

        private AtlasEditorImpl() {
        }

        @Override
        public Atlas getAtlas() {
            return AtlasImpl.this;
        }

        @Override
        public AtlasMetadataEditor getAtlasMetaDataEditor() {
            return AtlasImpl.this.metadata.getAtlasMetadataEditor();
        }

        @Override
        public DescripteursEditor getDescripteursEditor() {
            return AtlasImpl.this.descripteurs.getDescripteursEditor();
        }

        @Override
        public LiensEditor getLiensEditor() {
            return AtlasImpl.this.liens.getLiensEditor();
        }

        @Override
        public StructureEditor getStructureEditor() {
            return AtlasImpl.this.structure.getStructureEditor();
        }

        @Override
        public void endCompoundEvent(Object source, String name) {
            this.compoundEventProcessed = false;
            this.currentSource = null;
            this.currentName = null;
            CompoundAtlasEvent compoundAtlasEvent = new CompoundAtlasEvent(source, AtlasImpl.this, name);
            for (CompoundAtlasEventListener compoundAtlasEventListener : AtlasImpl.this.compoundAtlasEventListeners) {
                compoundAtlasEventListener.endCompoundAtlasEvent(compoundAtlasEvent);
            }
        }

        @Override
        public void startCompoundEvent(Object source, String name) {
            if (this.compoundEventProcessed) {
                throw new ConcurrentModificationException();
            }
            this.compoundEventProcessed = true;
            this.currentSource = source;
            this.currentName = name;
            CompoundAtlasEvent compoundAtlasEvent = new CompoundAtlasEvent(source, AtlasImpl.this, name);
            for (CompoundAtlasEventListener compoundAtlasEventListener : AtlasImpl.this.compoundAtlasEventListeners) {
                compoundAtlasEventListener.startCompoundAtlasEvent(compoundAtlasEvent);
            }
        }

        @Override
        public void insertExternalEvent(EventObject eventObject) {
            if (this.compoundEventProcessed) {
                CompoundAtlasEvent compoundAtlasEvent = new CompoundAtlasEvent(this.currentSource, AtlasImpl.this, this.currentName, eventObject);
                for (CompoundAtlasEventListener compoundAtlasEventListener : AtlasImpl.this.compoundAtlasEventListeners) {
                    compoundAtlasEventListener.externalEventInserted(compoundAtlasEvent);
                }
            }
        }

        @Override
        public boolean putAttribute(Object atlasAttributesHolder, Attribute attribute) {
            AttributeKey attributeKey = attribute.getAttributeKey();
            if (atlasAttributesHolder instanceof TermImpl) {
                TermImpl term = (TermImpl)atlasAttributesHolder;
                Attribute oldAttribute = term.getAttributes().getAttribute(attributeKey);
                boolean done = term.putAttribute(attribute);
                if (done) {
                    AtlasImpl.this.fireAttributeChanged(term, attributeKey, oldAttribute);
                    return true;
                }
            } else if (atlasAttributesHolder instanceof AtlasMetadataImpl) {
                AtlasMetadataImpl metadata = (AtlasMetadataImpl)atlasAttributesHolder;
                Attribute oldAttribute = metadata.getAttributes().getAttribute(attributeKey);
                boolean done = metadata.putAttribute(attribute);
                if (done) {
                    AtlasImpl.this.fireAttributeChanged(metadata, attributeKey, oldAttribute);
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean removeAttribute(Object atlasAttributesHolder, AttributeKey attributeKey) {
            if (atlasAttributesHolder instanceof TermImpl) {
                TermImpl term = (TermImpl)atlasAttributesHolder;
                Attribute oldAttribute = term.getAttributes().getAttribute(attributeKey);
                if (oldAttribute == null) {
                    return false;
                }
                boolean done = term.removeAttribute(attributeKey);
                if (done) {
                    AtlasImpl.this.fireAttributeRemoved(term, oldAttribute);
                    return true;
                }
            } else if (atlasAttributesHolder instanceof AtlasMetadataImpl) {
                AtlasMetadataImpl metadata = (AtlasMetadataImpl)atlasAttributesHolder;
                Attribute oldAttribute = metadata.getAttributes().getAttribute(attributeKey);
                if (oldAttribute == null) {
                    return false;
                }
                boolean done = metadata.removeAttribute(attributeKey);
                if (done) {
                    AtlasImpl.this.fireAttributeRemoved(metadata, oldAttribute);
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean putLibelle(Object atlasLabelHolder, Label libelle) {
            if (atlasLabelHolder instanceof TermImpl) {
                TermImpl term = (TermImpl)atlasLabelHolder;
                boolean done = term.putLabel(libelle);
                if (done) {
                    AtlasImpl.this.fireLabelChanged(term);
                }
                return done;
            }
            return false;
        }

        @Override
        public boolean removeLibelle(Object atlasLabelHolder, Lang lang) {
            if (atlasLabelHolder instanceof TermImpl) {
                TermImpl term = (TermImpl)atlasLabelHolder;
                boolean done = term.removeLabel(lang);
                if (done) {
                    AtlasImpl.this.fireLabelRemoved(term);
                }
                return done;
            }
            return false;
        }
    }
}

