/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmodo;

import fr.exemole.bdfext.desmodo.Desmodo;
import fr.exemole.bdfext.desmodo.Desmographie;
import fr.exemole.bdfext.desmodo.conf.Desmos;
import fr.exemole.bdfserver.api.BdfServer;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.conf.Conf;
import net.desmodo.atlas.io.AtlasIOException;
import net.desmodo.atlas.session.SessionIO;
import net.desmodo.atlas.session.SessionSource;
import net.desmodo.atlas.tools.ventilation.DefaultVentilationFactory;
import net.desmodo.atlas.ventilation.VentilationFactory;
import net.desmodo.atlas.xml.dsmd.DefaultDsmdDOMErrorHandler;
import net.desmodo.atlas.xml.dsmd.DsmdDOMErrorHandler;
import net.mapeadores.util.exceptions.NestedClassLoaderException;
import net.mapeadores.util.io.DocStream;

public class DesmodoManager {
    public static final String MANAGER_KEY = "desmodoManager";
    private boolean isInit = false;
    private Map<String, Integer> codeMap = new HashMap<String, Integer>();
    private Map<Integer, Desmographie> desmographieMap = new TreeMap<Integer, Desmographie>();
    private Desmographie[] desmographieArray;
    private int maxInt = 1;
    private VentilationFactory ventilationFactory = new DefaultVentilationFactory(null);

    public DesmodoManager() {
        try {
            SessionIO.setAtlasFactory("net.desmodo.atlas.impl.AtlasFactory");
        }
        catch (ReflectiveOperationException e) {
            throw new NestedClassLoaderException((Exception)e);
        }
    }

    public void init(BdfServer bdfServer, boolean reload) {
        if (this.isInit && !reload) {
            return;
        }
        DocStream docStream = bdfServer.getResourceStorages().getResourceDocStream(Desmodo.EXTENSION_RESOURCE_ROOT.buildChild("private/desmos.xml"));
        if (docStream == null) {
            return;
        }
        this.isInit = true;
        this.desmographieMap.clear();
        this.desmographieArray = null;
        Map<String, File> fileMap = Desmos.readDesmos(docStream);
        DefaultDsmdDOMErrorHandler dsmdDOMErrorHandler = new DefaultDsmdDOMErrorHandler();
        for (Map.Entry<String, File> entry : fileMap.entrySet()) {
            String name = entry.getKey();
            try {
                SessionSource sessionSource = SessionIO.loadSession(entry.getValue(), (DsmdDOMErrorHandler)dsmdDOMErrorHandler);
                Integer itg = this.codeMap.get(name);
                if (itg == null) {
                    itg = this.maxInt;
                    ++this.maxInt;
                    this.codeMap.put(name, itg);
                }
                this.desmographieMap.put(itg, new InternalDesmographie(itg, name, sessionSource.getAtlas(), sessionSource.getSessionConf()));
            }
            catch (AtlasIOException aioe) {
                System.out.println(aioe.getMessage());
            }
        }
        int size = this.desmographieMap.size();
        if (size > 0) {
            this.desmographieArray = new Desmographie[size];
            int p = 0;
            Iterator<Desmographie> iterator = this.desmographieMap.values().iterator();
            while (iterator.hasNext()) {
                Desmographie desmographie;
                this.desmographieArray[p] = desmographie = iterator.next();
                ++p;
            }
        }
    }

    public int getDesmographieCount() {
        if (this.desmographieArray == null) {
            return 0;
        }
        return this.desmographieArray.length;
    }

    public Desmographie getDesmographieByIndex(int i) {
        return this.desmographieArray[i];
    }

    public Desmographie getDesmographieByCode(int code) {
        return this.desmographieMap.get(code);
    }

    public Desmographie getDesmographieByName(String name) {
        Integer code = this.codeMap.get(name);
        if (code == null) {
            return null;
        }
        return this.desmographieMap.get(code);
    }

    public VentilationFactory getVentilationFactory() {
        return this.ventilationFactory;
    }

    private static class InternalDesmographie
    implements Desmographie {
        private final int code;
        private final String name;
        private final Atlas atlas;
        private final Conf sessionConf;

        private InternalDesmographie(int code, String name, Atlas atlas, Conf sessionConf) {
            this.code = code;
            this.name = name;
            this.atlas = atlas;
            this.sessionConf = sessionConf;
        }

        @Override
        public int getCode() {
            return this.code;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Atlas getAtlas() {
            return this.atlas;
        }

        @Override
        public Conf getSessionConf() {
            return this.sessionConf;
        }
    }
}

