/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.ventilation.builders;

import net.desmodo.atlas.Term;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.descripteurs.DescripteurList;
import net.desmodo.atlas.liens.LienHierarchique;
import net.desmodo.atlas.liens.LienHierarchiqueGroup;
import net.desmodo.atlas.liens.LienHierarchiqueGroupList;
import net.desmodo.atlas.liens.LienHierarchiqueList;
import net.desmodo.atlas.liens.LienStructurel;
import net.desmodo.atlas.liens.LienStructurelList;
import net.desmodo.atlas.liens.LienSymetrique;
import net.desmodo.atlas.liens.LienSymetriqueList;
import net.desmodo.atlas.liens.Liens;
import net.desmodo.atlas.liens.LiensUtils;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.ventilation.UnsupportedVentilationRootException;
import net.desmodo.atlas.ventilation.Ventilation;
import net.desmodo.atlas.ventilation.VentilationParameters;
import net.desmodo.atlas.ventilation.builders.DefaultVentilation;

public class ByFamilleVentilationBuilder {
    private ByFamilleVentilationBuilder() {
    }

    public static Ventilation toVentilation(VentilationParameters ventilationParameters) throws UnsupportedVentilationRootException {
        boolean ignoreSansFamille = ventilationParameters.getSessionConf().getBoolean("ignore.contexte.sansfamille");
        Term ventilationRoot = ventilationParameters.getVentilationRoot();
        DefaultVentilation defVentilation = DefaultVentilation.createVentilationByFamille(ventilationParameters, ignoreSansFamille);
        if (ventilationRoot != null) {
            if (ventilationRoot instanceof Descripteur) {
                ByFamilleVentilationBuilder.addLiaisons(defVentilation, (Descripteur)ventilationRoot);
            } else if (ventilationRoot instanceof Contexte) {
                ByFamilleVentilationBuilder.addLiaisons(defVentilation, (Contexte)ventilationRoot);
            } else {
                throw new UnsupportedVentilationRootException("ventilation:famille:* supports only Contexte or Descripteur as VentilationRoot", ByFamilleVentilationBuilder.class.getName());
            }
        }
        defVentilation.endInit();
        return defVentilation;
    }

    private static void addLiaisons(DefaultVentilation defVentilation, Contexte contexte) {
        Liens liens = defVentilation.getSource().getLiens();
        LienStructurelList lstList = liens.getLienStructurelList(contexte);
        int lienCount = lstList.getLienStructurelCount();
        if (lienCount > 0) {
            for (int i = 0; i < lienCount; ++i) {
                LienStructurel lienStructurel = lstList.getLienStructurel(i);
                DescripteurList list = lienStructurel.getDescripteurList();
                int descripteurCount = list.getDescripteurCount();
                for (int j = 0; j < descripteurCount; ++j) {
                    Descripteur desc = list.getDescripteur(j);
                    defVentilation.createLiaison(lienStructurel, desc, desc.getFamille(), i);
                }
            }
        }
    }

    private static void addLiaisons(DefaultVentilation defVentilation, Descripteur descripteur) {
        LienHierarchiqueGroupList lhgList;
        int groupCount;
        LienSymetriqueList lsmList;
        int lsmCount;
        Liens liens = defVentilation.getSource().getLiens();
        Liens.LienLists lienLists = liens.getLienLists(descripteur);
        LienHierarchiqueList lhList = lienLists.getLienHierarchiqueList();
        int lhCount = lhList.getLienHierarchiqueCount();
        if (lhCount > 0) {
            for (int i = 0; i < lhCount; ++i) {
                LienHierarchique lh = lhList.getLienHierarchique(i);
                Descripteur descpere = lh.getDescripteurPere();
                defVentilation.createLiaison(lh, descpere, descpere.getFamille());
            }
        }
        if ((lsmCount = (lsmList = lienLists.getLienSymetriqueList()).getLienSymetriqueCount()) > 0) {
            for (int i = 0; i < lsmCount; ++i) {
                LienSymetrique lsm = lsmList.getLienSymetrique(i);
                int index = LiensUtils.indexOf(lsm, descripteur);
                Descripteur autredescripteur = lsm.getDescripteur(LiensUtils.getSensInverse(index));
                defVentilation.createLiaison(lsm, autredescripteur, autredescripteur.getFamille());
            }
        }
        if ((groupCount = (lhgList = lienLists.getLienHierarchiqueGroupList()).getLienHierarchiqueGroupCount()) > 0) {
            for (int i = 0; i < groupCount; ++i) {
                LienHierarchiqueGroup lhg = lhgList.getLienHierarchiqueGroup(i);
                int lienCount = lhg.getLienHierarchiqueCount();
                for (int j = 0; j < lienCount; ++j) {
                    LienHierarchique lh = lhg.getLienHierarchique(j);
                    Descripteur descfils = lh.getDescripteurFils();
                    defVentilation.createLiaison(lh, descfils, descfils.getFamille());
                }
            }
        }
    }
}

