/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.ventilation;

import java.util.ArrayList;
import java.util.List;
import net.desmodo.atlas.Term;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.liens.Liens;
import net.desmodo.atlas.ventilation.Liaison;
import net.desmodo.atlas.ventilation.LiaisonList;
import net.desmodo.atlas.ventilation.Secteur;
import net.desmodo.atlas.ventilation.SecteurList;
import net.desmodo.atlas.ventilation.Ventilation;

public class Transversalite {
    public static final int END = 1;
    public static final int START = 2;
    public static final int BOTH = 3;
    private List<TransversaliteItem> transversaliteItemList = new ArrayList<TransversaliteItem>();
    private List<Liaison> liaisons = new ArrayList<Liaison>();

    public Transversalite(Ventilation ventilation) {
        this.init(ventilation.getSource().getLiens(), ventilation);
        this.liaisons = null;
    }

    public List<TransversaliteItem> getTransversaliteItemList() {
        return this.transversaliteItemList;
    }

    private void init(Liens liens, Ventilation ventilation) {
        this.initSecteurList(liens, ventilation.getFirstLevelSecteurList());
    }

    private void initSecteurList(Liens liens, SecteurList liste) {
        int secteurCount = liste.getSecteurCount();
        if (secteurCount == 0) {
            return;
        }
        for (int i = 0; i < secteurCount; ++i) {
            this.init(liens, liste.getSecteur(i));
        }
    }

    private void init(Liens liens, Secteur secteur) {
        LiaisonList liaisonList = secteur.getLiaisonList();
        int liaisonCount = liaisonList.getLiaisonCount();
        if (liaisonCount > 0) {
            for (int j = 0; j < liaisonCount; ++j) {
                Liaison liaison = liaisonList.getLiaison(j);
                Term term = liaison.getTerm();
                if (!(term instanceof Descripteur)) continue;
                Descripteur descripteur = (Descripteur)term;
                int size = this.liaisons.size();
                for (int i = 0; i < size; ++i) {
                    Liaison other = this.liaisons.get(i);
                    Descripteur od = (Descripteur)other.getTerm();
                    if (od.equals(descripteur)) continue;
                    Liens.LienLists liensLists = liens.getLienLists(descripteur, od);
                    int type = 0;
                    if (liensLists.getLienSymetriqueList().getLienSymetriqueCount() > 0) {
                        type = 3;
                    } else {
                        if (liensLists.getLienHierarchiqueList().getLienHierarchiqueCount() > 0) {
                            type += 2;
                        }
                        if (liensLists.getLienHierarchiqueGroupList().getLienHierarchiqueGroupCount() > 0) {
                            ++type;
                        }
                    }
                    if (type <= 0) continue;
                    this.transversaliteItemList.add(new TransversaliteItem(type, liaison, other));
                }
                this.liaisons.add(liaison);
            }
        }
        this.initSecteurList(liens, secteur.getChildren());
    }

    public class TransversaliteItem {
        private int liaison1VentilationCode;
        private int liaison2VentilationCode;
        private int type;

        TransversaliteItem(int type, Liaison liaison1, Liaison liaison2) {
            this.type = type;
            this.liaison1VentilationCode = liaison1.getVentilationCode();
            this.liaison2VentilationCode = liaison2.getVentilationCode();
        }

        public int getTransversaliteType() {
            return this.type;
        }

        public int getLiaison1VentilationCode() {
            return this.liaison1VentilationCode;
        }

        public int getLiaison2VentilationCode() {
            return this.liaison2VentilationCode;
        }
    }
}

