/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.tablesexport;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.AtlasUtils;
import net.desmodo.atlas.Term;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.descripteurs.DescripteurList;
import net.desmodo.atlas.descripteurs.Descripteurs;
import net.desmodo.atlas.descripteurs.DescripteursUtils;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.structure.ContexteList;
import net.desmodo.atlas.structure.Grille;
import net.desmodo.atlas.structure.GrilleList;
import net.desmodo.atlas.structure.Structure;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.xml.SxcWriter;

public class AtlasSxcWriter
extends SxcWriter {
    public void writeAtlas(Atlas atlas) throws IOException {
        this.writeStructure(atlas.getStructure());
        this.writeDescripteurs(atlas.getDescripteurs());
    }

    public void writeStructure(Structure structure) throws IOException {
        GrilleList grilleList = structure.getGrilleList();
        int grilleCount = grilleList.getGrilleCount();
        for (int i = 0; i < grilleCount; ++i) {
            this.writeGrille(grilleList.getGrille(i));
        }
        this.writeGrille(structure.getGrilleDesFamilles());
    }

    public void writeGrille(Grille grille) throws IOException {
        String grilleName = grille.getGrilleName();
        String pageName = grilleName.length() == 0 ? "familles" : "grille_" + grilleName;
        this.openTable(pageName);
        Set<Lang> langSet = AtlasUtils.getUsedLangSet(grille);
        Lang[] langArray = langSet.toArray(new Lang[langSet.size()]);
        this.openRow();
        this.addStringCellElement("idctxt");
        this.addStringCellElement("parent_idctxt");
        for (Lang lang : langArray) {
            this.addStringCellElement("lib_" + lang.toString());
            this.addStringCellElement("vo_" + lang.toString());
        }
        this.closeRow();
        ContexteList contexteList = grille.getFirstLevelContexteList();
        int contexteCount = contexteList.getContexteCount();
        for (int i = 0; i < contexteCount; ++i) {
            this.writeContexte(contexteList.getContexte(i), langArray);
        }
        this.endTable();
    }

    public void writeDescripteurs(Descripteurs descripteurs) throws IOException {
        Set<Lang> langSet = AtlasUtils.getUsedLangSet(descripteurs);
        Lang[] langArray = langSet.toArray(new Lang[langSet.size()]);
        List<DescripteurList> descripteursLists = DescripteursUtils.getListOfDescripteurList(descripteurs);
        this.openTable("descripteurs");
        this.openRow();
        this.addStringCellElement("iddesc");
        this.addStringCellElement("famille_idctxt");
        for (Lang lang : langArray) {
            this.addStringCellElement("lib_" + lang.toString());
            this.addStringCellElement("vo_" + lang.toString());
        }
        this.closeRow();
        for (DescripteurList descripteurList : descripteursLists) {
            int descripteurCount = descripteurList.getDescripteurCount();
            for (int i = 0; i < descripteurCount; ++i) {
                Descripteur descripteur = descripteurList.getDescripteur(i);
                this.openRow();
                this.addStringCellElement(descripteur.getIddesc().toString());
                Contexte famille = descripteur.getFamille();
                if (famille != null) {
                    this.addStringCellElement(famille.getIdctxt());
                } else {
                    this.addEmptyCell();
                }
                this.writeLib(descripteur, langArray);
                this.closeRow();
            }
        }
        this.endTable();
    }

    private void writeContexte(Contexte contexte, Lang[] langArray) throws IOException {
        this.openRow();
        this.addStringCellElement(contexte.getIdctxt());
        Contexte parent = contexte.getParent();
        if (parent == null) {
            this.addEmptyCell();
        } else {
            this.addStringCellElement(parent.getIdctxt());
        }
        this.writeLib(contexte, langArray);
        this.closeRow();
        ContexteList contexteList = contexte.getChildren();
        int contexteCount = contexteList.getContexteCount();
        for (int i = 0; i < contexteCount; ++i) {
            this.writeContexte(contexteList.getContexte(i), langArray);
        }
    }

    private void writeLib(Term term, Lang[] langArray) throws IOException {
        for (Lang lang : langArray) {
            Label libelle = term.getLabels().getLabel(lang);
            if (libelle == null) {
                this.addEmptyCell();
                continue;
            }
            this.addStringCellElement(libelle.getLabelString());
        }
    }
}

