/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.session;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import net.desmodo.atlas.AtlasEditor;
import net.desmodo.atlas.AtlasFactory;
import net.desmodo.atlas.io.AtlasIO;
import net.desmodo.atlas.io.AtlasIOException;
import net.desmodo.atlas.session.DefaultSessionSource;
import net.desmodo.atlas.session.SessionConf;
import net.desmodo.atlas.session.SessionIOConstants;
import net.desmodo.atlas.session.SessionSource;
import net.desmodo.atlas.xml.dsmd.DsmdDOMErrorHandler;
import net.desmodo.atlas.xml.dsmd.DsmdIO;
import org.w3c.dom.Document;

public final class SessionIO
implements SessionIOConstants {
    private static AtlasFactory atlasFactory;

    private SessionIO() {
    }

    public static void setAtlasFactory(String atlasFactoryClassname) throws ReflectiveOperationException {
        Class<?> atlasFactoryClass = Class.forName(atlasFactoryClassname);
        atlasFactory = (AtlasFactory)atlasFactoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static SessionSource loadSession(URI uri, DsmdDOMErrorHandler errorHandler) throws AtlasIOException {
        Object obj = AtlasIO.translate(uri);
        if (obj instanceof File) {
            return SessionIO.loadSession((File)obj, errorHandler);
        }
        return SessionIO.loadSession((URL)obj, errorHandler);
    }

    public static SessionSource loadSession(URL url, DsmdDOMErrorHandler errorHandler) throws AtlasIOException {
        InputStream inputStream = AtlasIO.getInputStream(url);
        return SessionIO.loadSession(inputStream, errorHandler);
    }

    public static SessionSource loadSession(File file, DsmdDOMErrorHandler errorHandler) throws AtlasIOException {
        InputStream inputStream = AtlasIO.getInputStream(file);
        return SessionIO.loadSession(inputStream, errorHandler);
    }

    public static SessionSource loadSession(InputStream inputStream, DsmdDOMErrorHandler errorHandler) throws AtlasIOException {
        Document document = AtlasIO.getDocument(inputStream);
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        SessionSource sessionSource = SessionIO.newSessionSource();
        DsmdIO.parseDocument(document, sessionSource, errorHandler);
        return sessionSource;
    }

    public static SessionSource newSessionSource() {
        AtlasEditor atlasEditor = atlasFactory.newAtlasEditor();
        return new DefaultSessionSource(atlasEditor, new SessionConf());
    }
}

