/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.session;

import java.awt.Font;
import net.desmodo.atlas.conf.AbstractConf;
import net.desmodo.atlas.session.SessionConfKeys;
import net.desmodo.atlas.ventilation.VentilationName;
import net.mapeadores.util.localisation.Lang;

public class SessionConf
extends AbstractConf
implements SessionConfKeys {
    private static final Lang DEFAULT_LANG = Lang.build((String)"fr");

    public SessionConf() {
        this.putBoolean("ignore.empty.secteur", true);
        this.putBoolean("ignore.contexte.sansfamille", false);
        this.putBoolean("ignore.contexte.horsgrille", false);
        this.putBoolean("extension.transversalite", false);
        this.putString("home.ventilationname", VentilationName.VENTILATION_NATURELLE.toString());
        this.putString("home.ventilationroot", "special:null");
        this.putLang("lang.current", DEFAULT_LANG);
        this.putPositiveInteger("skin.linelength", 21);
        this.putFont("skin.font.bordure", new Font("SansSerif", 0, 12));
        this.putFont("skin.font.liaison", new Font("SansSerif", 0, 11));
        this.putString("atlas.iddesc.prefix", "");
        this.putBoolean("trans.unsaved.atlas", false);
        this.putBoolean("trans.unsaved.conf", false);
        this.putBoolean("trans.undoable.atlas", false);
        this.putFile("trans.file", null);
        this.putBoolean("ventparam.famille.recursive", true);
        this.putBoolean("file.template", false);
        this.putBoolean("limitation.familles", false);
        this.putBoolean("limitation.liens", false);
        this.putStringArray("limitation.familles.idctxtarray", new String[0]);
        this.putStringArray("limitation.liens.typearray", new String[0]);
        this.putPositiveInteger("skin.chapeaulength", 33);
        this.putBoolean("skin.linelimitation", false);
        this.putPositiveInteger("skin.linemax", 3);
        this.putURL("trans.url", null);
        this.putBoolean("display.link", true);
        this.putBoolean("display.poids", true);
        this.putBoolean("display.lientype", true);
        String[] familleTypeArray = new String[]{"lh_av", "lsm"};
        this.putStringArray("ventparam.famille.liens.typearray", familleTypeArray);
        this.putBoolean("lang.defaultlib", true);
        this.putInteger("trans.lastfamille.code", -1);
        this.putBoolean("display.lienindex", false);
    }

    public SessionConf(SessionConf sessionConf) {
        this.addAll(sessionConf);
    }

    @Override
    public boolean isTransient(String paramName) {
        return paramName.startsWith("trans.");
    }

    @Override
    public String getAlias(String name) {
        if (name.equals("ignore.empty.grilleorcontexte")) {
            return "ignore.empty.secteur";
        }
        return null;
    }

    @Override
    public boolean isObsolete(String name) {
        if (name.equals("ignore.empty.famille")) {
            return true;
        }
        return name.equals("ignore.empty.descripteur");
    }

    public static boolean concernSkin(String paramName) {
        if (paramName.startsWith("skin.")) {
            return true;
        }
        return paramName.startsWith("lang.");
    }

    public static boolean concernLiaisonFilter(String paramName) {
        return paramName.startsWith("limitation.");
    }

    public static boolean concernVentilationFilter(String paramName) {
        if (paramName.startsWith("ignore.")) {
            return true;
        }
        return paramName.startsWith("limitation.");
    }
}

