/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.display.secteurs;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.io.IOException;
import net.desmodo.atlas.display.AwtSvgWriter;
import net.desmodo.atlas.display.SxdWriter;
import net.desmodo.atlas.display.Translation;
import net.desmodo.atlas.display.secteurs.FaisceauAngulaire;
import net.desmodo.atlas.display.secteurs.secteurangulaire.SecteurAngulaire;
import net.desmodo.atlas.display.secteurs.secteurangulaire.Sommet;
import net.mapeadores.util.geometry.CartesianOrigin;

public class SecteurDisplay {
    CartesianOrigin cartesianOrigin;
    Dimension AB;
    Point K;
    boolean drawLine;
    FaisceauAngulaire faisceauAngulaire;

    private SecteurDisplay(FaisceauAngulaire faisceauAngulaire, CartesianOrigin cartesianOrigin) {
        this.cartesianOrigin = cartesianOrigin;
        this.faisceauAngulaire = faisceauAngulaire;
        this.AB = faisceauAngulaire.getAB();
        this.K = cartesianOrigin.toGraphicPoint(faisceauAngulaire.getCartesianCenter());
        this.drawLine = faisceauAngulaire.getSecteurAngulaireCount() > 1;
    }

    public static void paint(FaisceauAngulaire faisceauAngulaire, CartesianOrigin cartesianOrigin, Graphics2D g) {
        if (faisceauAngulaire.getSecteurAngulaireCount() == 0) {
            return;
        }
        SecteurDisplay secteurDisplay = new SecteurDisplay(faisceauAngulaire, cartesianOrigin);
        secteurDisplay.paint(g);
    }

    public static void exportSXD(FaisceauAngulaire faisceauAngulaire, CartesianOrigin cartesianOrigin, SxdWriter sxdwriter, String layerName) throws IOException {
        if (faisceauAngulaire.getSecteurAngulaireCount() == 0) {
            return;
        }
        SecteurDisplay secteurDisplay = new SecteurDisplay(faisceauAngulaire, cartesianOrigin);
        secteurDisplay.exportSXD(sxdwriter, layerName);
    }

    public static void exportSVG(FaisceauAngulaire faisceauAngulaire, CartesianOrigin cartesianOrigin, AwtSvgWriter svgWriter, Translation translation) throws IOException {
        if (faisceauAngulaire.getSecteurAngulaireCount() == 0) {
            return;
        }
        SecteurDisplay secteurDisplay = new SecteurDisplay(faisceauAngulaire, cartesianOrigin);
        secteurDisplay.exportSVG(svgWriter, translation);
    }

    private void exportSVG(AwtSvgWriter svgWriter, Translation translation) throws IOException {
        this.K = translation.translate(this.K);
        int length = this.faisceauAngulaire.getSecteurAngulaireCount();
        if (length == 1) {
            svgWriter.startEllipseOpentag(this.K.x, this.K.y, this.AB.width, this.AB.height);
            svgWriter.addStrokeAttribute(this.faisceauAngulaire.getSecteurAngulaire(0).getArcColorStyle().getColor());
            svgWriter.addFillAttribute(null);
            svgWriter.closeEmptyTag();
        } else {
            for (int i = 0; i < length; ++i) {
                SecteurAngulaire secteurAngulaire = this.faisceauAngulaire.getSecteurAngulaire(i);
                this.exportSVG(svgWriter, translation, secteurAngulaire);
            }
        }
    }

    private void exportSVG(AwtSvgWriter svgWriter, Translation translation, SecteurAngulaire secteurAngulaire) throws IOException {
        Sommet firstSommet = secteurAngulaire.getFirstSommet();
        Sommet secondSommet = secteurAngulaire.getSecondSommet();
        Point S1 = translation.translate(this.cartesianOrigin.toGraphicPoint(firstSommet.getCartesianPoint()));
        Point S2 = translation.translate(this.cartesianOrigin.toGraphicPoint(secondSommet.getCartesianPoint()));
        if (this.drawLine) {
            Color previousColor = secteurAngulaire.getSeparatorWithPreviousColorStyle().getColor();
            svgWriter.startLineOpenTag(this.K.x, this.K.y, S1.x, S1.y);
            svgWriter.addStrokeAttribute(previousColor);
            svgWriter.closeEmptyTag();
        }
        int startAngle = firstSommet.getGraphicTrigoAngle();
        int arcAngle = secondSommet.getGraphicTrigoAngle() - startAngle;
        svgWriter.startArcPathOpenTag(S1.x, S1.y, this.AB.width, this.AB.height, 0, arcAngle >= 180, false, S2.x, S2.y);
        svgWriter.addFillAttribute(null);
        svgWriter.addStrokeAttribute(secteurAngulaire.getArcColorStyle().getColor());
        svgWriter.closeEmptyTag();
    }

    private void paint(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.BLACK);
        int length = this.faisceauAngulaire.getSecteurAngulaireCount();
        for (int i = 0; i < length; ++i) {
            SecteurAngulaire secteurAngulaire = this.faisceauAngulaire.getSecteurAngulaire(i);
            this.paint(g, secteurAngulaire);
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    private void paint(Graphics2D g, SecteurAngulaire secteurAngulaire) {
        Sommet firstSommet = secteurAngulaire.getFirstSommet();
        Sommet secondSommet = secteurAngulaire.getSecondSommet();
        g.setColor(secteurAngulaire.getSeparatorWithPreviousColorStyle().getColor());
        if (this.drawLine) {
            Point S = this.cartesianOrigin.toGraphicPoint(firstSommet.getCartesianPoint());
            g.drawLine(this.K.x, this.K.y, S.x, S.y);
        }
        int startAngle = firstSommet.getGraphicTrigoAngle();
        int arcAngle = secondSommet.getGraphicTrigoAngle() - startAngle;
        g.setColor(secteurAngulaire.getArcColorStyle().getColor());
        g.drawArc(this.K.x - this.AB.width, this.K.y - this.AB.height, this.AB.width * 2 + 1, this.AB.height * 2 + 1, startAngle, arcAngle);
    }

    private void exportSXD(SxdWriter sxdwriter, String layerName) throws IOException {
        int length = this.faisceauAngulaire.getSecteurAngulaireCount();
        for (int i = 0; i < length; ++i) {
            SecteurAngulaire secteurAngulaire = this.faisceauAngulaire.getSecteurAngulaire(i);
            this.exportSXD(sxdwriter, layerName, secteurAngulaire);
        }
    }

    private void exportSXD(SxdWriter sxdwriter, String layerName, SecteurAngulaire secteurAngulaire) throws IOException {
        Sommet firstSommet = secteurAngulaire.getFirstSommet();
        Sommet secondSommet = secteurAngulaire.getSecondSommet();
        if (this.drawLine) {
            Point S = this.cartesianOrigin.toGraphicPoint(firstSommet.getCartesianPoint());
            sxdwriter.addLineElement(new Point(this.K.x, this.K.y), S, layerName, secteurAngulaire.getSeparatorWithPreviousColorStyle().getName());
        }
        int startAngle = firstSommet.getGraphicTrigoAngle();
        int arcAngle = secondSommet.getGraphicTrigoAngle() - startAngle;
        sxdwriter.addArcElement(this.K.x - this.AB.width, this.K.y - this.AB.height, this.AB.width * 2, this.AB.height * 2, startAngle, arcAngle, layerName, secteurAngulaire.getArcColorStyle().getName());
    }
}

