/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.display.layers.common;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.io.IOException;
import java.util.List;
import net.desmodo.atlas.display.AwtSvgWriter;
import net.desmodo.atlas.display.GraphicsUtils;
import net.desmodo.atlas.display.Translation;
import net.desmodo.atlas.display.blocks.LinkBlock;
import net.desmodo.atlas.display.layers.common.LinkLayer;

public class LinkLayerDisplay {
    static final Color FOND = new Color(0, 0, 128);
    static final Color FLECHE = new Color(255, 255, 0);

    private LinkLayerDisplay() {
    }

    public static void paint(LinkLayer linkLayer, Graphics2D g2) {
        List list = linkLayer.getLinkBlockList();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            LinkLayerDisplay.paintLinkBlock((LinkBlock)list.get(i), g2);
        }
    }

    private static void paintLinkBlock(LinkBlock linkBlock, Graphics2D g) {
        Point location = linkBlock.getLocation();
        Dimension dim = linkBlock.getSize();
        int x = location.x;
        int y = location.y;
        g.setColor(FOND);
        g.fillRect(x, y, dim.width, dim.height);
        g.setColor(FLECHE);
        GraphicsUtils.drawHorizontalLine(g, x + 2, (y += 2) + 3, 8);
        GraphicsUtils.drawPoint(g, x + 7, y + 1);
        GraphicsUtils.drawPoint(g, x + 7, y + 5);
        GraphicsUtils.drawPoint(g, x + 8, y + 2);
        GraphicsUtils.drawPoint(g, x + 8, y + 4);
    }

    public static void exportSVG(LinkLayer linkLayer, AwtSvgWriter svgWriter, Translation translation) throws IOException {
        List list = linkLayer.getLinkBlockList();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            LinkLayerDisplay.exportSVGLinkBlock((LinkBlock)list.get(i), svgWriter, translation);
        }
    }

    private static void exportSVGLinkBlock(LinkBlock linkBlock, AwtSvgWriter svgWriter, Translation translation) throws IOException {
        Point location = linkBlock.getLocation();
        Dimension dim = linkBlock.getSize();
        int x = location.x + translation.getWestTranslation();
        int y = location.y + translation.getNorthTranslation();
        svgWriter.startAOpenTag(linkBlock.getUrlString());
        svgWriter.endOpenTag();
        svgWriter.startGroupOpenTag();
        svgWriter.endOpenTag();
        svgWriter.startRectOpenTag(x, y, dim.width, dim.height);
        svgWriter.addFillAttribute(FOND);
        svgWriter.closeEmptyTag();
        LinkLayerDisplay.exportLine(x + 2, (y += 2) + 3, x + 10, y + 3, svgWriter);
        LinkLayerDisplay.exportLine(x + 7, y + 5, x + 10, y + 3, svgWriter);
        LinkLayerDisplay.exportLine(x + 7, y + 1, x + 10, y + 3, svgWriter);
        svgWriter.closeGroup();
        svgWriter.closeA();
    }

    private static void exportLine(int x1, int y1, int x2, int y2, AwtSvgWriter svgWriter) throws IOException {
        svgWriter.startLineOpenTag(x1, y1, x2, y2);
        svgWriter.addStrokeAttribute(FLECHE);
        svgWriter.closeEmptyTag();
    }
}

