/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.display.layers.common;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.desmodo.atlas.display.GraphicsUtils;
import net.desmodo.atlas.display.blocks.BlockLocator;
import net.desmodo.atlas.display.blocks.LiaisonBlock;
import net.desmodo.atlas.display.icons.AmontIcon;
import net.desmodo.atlas.display.icons.EgalIcon;
import net.desmodo.atlas.display.layers.Layer;

public class LienTypeLayer
implements Layer {
    private BlockLocator blockLocator;
    private final List<SmallIcon> iconList = new ArrayList<SmallIcon>();
    private String name;
    private int index;

    @Override
    public void setBlockLocator(BlockLocator blockLocator) {
        this.blockLocator = blockLocator;
    }

    @Override
    public void update() {
        this.iconList.clear();
        for (LiaisonBlock liaisonBlock : this.blockLocator.getLiaisonBlockList()) {
            Point P;
            Rectangle rect;
            short boxType = liaisonBlock.getBoxType();
            if (boxType == 1) {
                rect = liaisonBlock.getRectangle();
                P = new Point(rect.x, rect.y + rect.height - 1);
                this.iconList.add(new InternalAmontIcon(P, liaisonBlock.getBoxSkin().getBorderColor()));
                continue;
            }
            if (boxType != 3) continue;
            rect = liaisonBlock.getRectangle();
            P = new Point(rect.x, rect.y + rect.height - 1);
            this.iconList.add(new InternalEgalIcon(P, liaisonBlock.getBoxSkin().getBorderColor()));
        }
    }

    @Override
    public void paintLayer(Graphics2D g) {
        g.setColor(Color.RED);
        int size = this.iconList.size();
        for (int i = 0; i < size; ++i) {
            SmallIcon smallIcon = this.iconList.get(i);
            smallIcon.paint(g);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    private class InternalAmontIcon
    extends SmallIcon {
        private final Point P;
        private final Color borderColor;
        private final AmontIcon amontIcon;

        private InternalAmontIcon(Point P, Color borderColor) {
            this.amontIcon = new AmontIcon();
            this.P = P;
            this.borderColor = borderColor;
            this.amontIcon.setBackgroundColor(Color.WHITE);
        }

        @Override
        void paint(Graphics2D g) {
            int x = this.P.x;
            int y = this.P.y - 6;
            g.setColor(this.borderColor);
            GraphicsUtils.drawHorizontalLine(g, x + 1, y, 6);
            GraphicsUtils.drawVerticalLine(g, x + 6, y + 1, 6);
            this.amontIcon.paintIcon(null, g, x - 2, y + 1);
        }
    }

    private class InternalEgalIcon
    extends SmallIcon {
        private final Point P;
        private final Color borderColor;
        private final EgalIcon egalIcon;

        private InternalEgalIcon(Point P, Color borderColor) {
            this.egalIcon = new EgalIcon();
            this.P = P;
            this.borderColor = borderColor;
            this.egalIcon.setBackgroundColor(Color.WHITE);
        }

        @Override
        void paint(Graphics2D g) {
            int x = this.P.x;
            int y = this.P.y - 6;
            g.setColor(this.borderColor);
            GraphicsUtils.drawHorizontalLine(g, x + 1, y, 6);
            GraphicsUtils.drawVerticalLine(g, x + 6, y + 1, 6);
            this.egalIcon.paintIcon(null, g, x - 2, y + 1);
        }
    }

    private abstract class SmallIcon {
        private SmallIcon() {
        }

        abstract void paint(Graphics2D var1);
    }
}

