/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.display.icons;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public abstract class LienIcon
implements Icon {
    private Color backgroundColor;
    private int innerHeight = 8;
    private int innerWidth = 8;
    private int height = 8;
    private int width = 8;
    private int borderSize = 0;
    private int paddingSize = 0;
    private Color borderColor;

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setBorder(int borderSize, Color borderColor) {
        this.borderColor = borderColor;
        this.borderSize = borderSize;
        this.update();
    }

    public void setPadding(int paddingSize) {
        this.paddingSize = paddingSize;
        this.update();
    }

    public void setInnerDimension(int innerWidth, int innerHeight) {
        this.innerWidth = innerWidth;
        this.innerHeight = innerHeight;
        this.update();
    }

    private void update() {
        this.height = this.innerHeight + this.borderSize * 2 + this.paddingSize * 2;
        this.width = this.innerWidth + this.borderSize * 2 + this.paddingSize * 2;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public void paintIcon(Component component, Graphics g, int x, int y) {
        Color oldColor = g.getColor();
        if (this.borderSize > 0) {
            if (this.borderColor != null) {
                g.setColor(this.borderColor);
                for (int i = 0; i < this.borderSize; ++i) {
                    g.drawRect(x + i, y + i, this.width - 2 * i - 1, this.height - 2 * i - 1);
                }
            }
            x += this.borderSize;
            y += this.borderSize;
        }
        if (this.backgroundColor != null) {
            g.setColor(this.backgroundColor);
            g.fillRect(x, y, this.innerWidth + this.paddingSize * 2, this.innerHeight + this.paddingSize * 2);
        }
        this.paintFigure(g, x += this.paddingSize, y += this.paddingSize);
        g.setColor(oldColor);
    }

    protected abstract void paintFigure(Graphics var1, int var2, int var3);
}

