/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.conf;

import java.util.function.Consumer;
import net.desmodo.atlas.conf.AbstractConf;
import net.desmodo.atlas.conf.ConfDOMErrorHandler;
import net.mapeadores.util.xml.DOMUtils;
import org.w3c.dom.Element;

public class ConfDOMReader {
    private final ConfDOMErrorHandler errorHandler;
    private final AbstractConf conf;

    public ConfDOMReader(AbstractConf conf, ConfDOMErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        this.conf = conf;
    }

    public void readConf(Element element_xml) {
        DOMUtils.readChildren((Element)element_xml, (Consumer)new ConfConsumer());
    }

    private class ConfConsumer
    implements Consumer<Element> {
        private ConfConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("param")) {
                String name = element.getAttribute("name");
                if (name.length() == 0) {
                    ConfDOMReader.this.errorHandler.missingParamNameAttributeError();
                    return;
                }
                String value = element.getAttribute("value");
                short result = ConfDOMReader.this.conf.set(name, value);
                if (result == -1) {
                    ConfDOMReader.this.errorHandler.unknownKeyWarning(name);
                } else if (result == -2) {
                    ConfDOMReader.this.errorHandler.badValueError(name, value);
                }
            } else {
                ConfDOMReader.this.errorHandler.unknownTagWarning(tagName);
            }
        }
    }
}

