/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmodo.json;

import fr.exemole.bdfext.desmodo.json.AbstractJsonProducer;
import java.awt.Color;
import java.io.IOException;
import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.AtlasAttributes;
import net.desmodo.atlas.Term;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.descripteurs.DescripteurList;
import net.desmodo.atlas.descripteurs.Descripteurs;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.structure.ContexteList;
import net.desmodo.atlas.structure.Grille;
import net.desmodo.atlas.structure.GrilleList;
import net.desmodo.atlas.structure.Structure;
import net.desmodo.atlas.structure.StructureUtils;
import net.mapeadores.util.awt.ColorUtils;
import net.mapeadores.util.json.JSONWriter;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.Label;

public class AtlasJsonProducer
extends AbstractJsonProducer {
    private final Atlas atlas;
    private final Lang[] langArray;

    public AtlasJsonProducer(Atlas atlas, Lang[] langArray) {
        this.atlas = atlas;
        this.langArray = langArray;
    }

    public void writeJson(Appendable appendable) throws IOException {
        JSONWriter jsonWriter = new JSONWriter(appendable);
        jsonWriter.object();
        jsonWriter.key("structure");
        jsonWriter.object();
        this.writeStructure(jsonWriter, this.atlas.getStructure());
        jsonWriter.endObject();
        jsonWriter.key("descripteurs");
        jsonWriter.object();
        this.writeDescripteurs(jsonWriter, this.atlas.getDescripteurs());
        jsonWriter.endObject();
        this.writeWarnings(jsonWriter);
        jsonWriter.endObject();
    }

    private void writeStructure(JSONWriter jsonWriter, Structure structure) throws IOException {
        jsonWriter.key("specialcontextes");
        jsonWriter.object();
        jsonWriter.key("horsgrille");
        this.writeContexte(jsonWriter, structure.getSpecialContexte((short)5));
        jsonWriter.key("sansfamille");
        this.writeContexte(jsonWriter, structure.getSpecialContexte((short)6));
        jsonWriter.endObject();
        jsonWriter.key("familles");
        this.writeGrille(jsonWriter, structure.getGrilleDesFamilles());
        GrilleList grilleList = structure.getGrilleList();
        int grilleCount = grilleList.getGrilleCount();
        if (grilleCount > 0) {
            jsonWriter.key("grilleArray");
            jsonWriter.array();
            for (int i = 0; i < grilleCount; ++i) {
                this.writeGrille(jsonWriter, grilleList.getGrille(i));
            }
            jsonWriter.endArray();
        }
    }

    private void writeDescripteurs(JSONWriter jsonWriter, Descripteurs descripteurs) throws IOException {
        DescripteurList sansfamilleDescripteurList;
        int descripteurCount;
        Structure structure = descripteurs.getAtlas().getStructure();
        ContexteList liste = StructureUtils.getContexteList(structure.getGrilleDesFamilles(), false);
        int contexteCount = liste.getContexteCount();
        if (contexteCount > 0) {
            jsonWriter.key("infamilleArray");
            jsonWriter.array();
            for (int i = 0; i < contexteCount; ++i) {
                Contexte famille = liste.getContexte(i);
                DescripteurList infamilleDescripteurList = descripteurs.getInFamilleDescripteurList(famille);
                int descripteurCount2 = infamilleDescripteurList.getDescripteurCount();
                if (descripteurCount2 <= 0) continue;
                jsonWriter.object();
                jsonWriter.key("codefamille");
                jsonWriter.value((long)famille.getCode());
                jsonWriter.key("descripteurArray");
                jsonWriter.array();
                for (int j = 0; j < descripteurCount2; ++j) {
                    this.writeDescripteur(jsonWriter, infamilleDescripteurList.getDescripteur(j));
                }
                jsonWriter.endArray();
                jsonWriter.endObject();
            }
            jsonWriter.endArray();
        }
        if ((descripteurCount = (sansfamilleDescripteurList = descripteurs.getInFamilleDescripteurList(StructureUtils.getSansfamilleContexte(structure))).getDescripteurCount()) > 0) {
            jsonWriter.key("sansfamille");
            jsonWriter.object();
            jsonWriter.key("descripteurArray");
            jsonWriter.array();
            for (int i = 0; i < descripteurCount; ++i) {
                this.writeDescripteur(jsonWriter, sansfamilleDescripteurList.getDescripteur(i));
            }
            jsonWriter.endArray();
            jsonWriter.endObject();
        }
    }

    private void writeDescripteur(JSONWriter jsonWriter, Descripteur descripteur) throws IOException {
        jsonWriter.object();
        jsonWriter.key("iddesc");
        jsonWriter.value((Object)descripteur.getIddesc().toString());
        this.writeCommon(jsonWriter, descripteur);
        jsonWriter.key("codefamille");
        jsonWriter.value((long)descripteur.getFamille().getCode());
        jsonWriter.endObject();
    }

    private void writeGrille(JSONWriter jsonWriter, Grille grille) throws IOException {
        jsonWriter.object();
        this.writeCommon(jsonWriter, grille);
        jsonWriter.key("grillename");
        jsonWriter.value((Object)grille.getGrilleName());
        jsonWriter.key("color");
        jsonWriter.value((Object)ColorUtils.toHexFormat((Color)AtlasAttributes.getColor(grille)));
        ContexteList firstLevel = grille.getFirstLevelContexteList();
        int firstCount = firstLevel.getContexteCount();
        if (firstCount > 0) {
            jsonWriter.key("contexteArray");
            jsonWriter.array();
            for (int i = 0; i < firstCount; ++i) {
                this.writeContexte(jsonWriter, firstLevel.getContexte(i));
            }
            jsonWriter.endArray();
        }
        jsonWriter.endObject();
    }

    private void writeContexte(JSONWriter jsonWriter, Contexte contexte) throws IOException {
        jsonWriter.object();
        this.writeCommon(jsonWriter, contexte);
        short type = contexte.getTermType();
        if (type == 3 || type == 4) {
            jsonWriter.key("idctxt");
            jsonWriter.value((Object)contexte.getIdctxt());
            jsonWriter.key("codegrille");
            jsonWriter.value((long)contexte.getGrille().getCode());
            jsonWriter.key("index");
            jsonWriter.value((long)contexte.getChildIndex());
            Contexte parent = contexte.getParent();
            if (parent != null) {
                jsonWriter.key("codeparent");
                jsonWriter.value((long)contexte.getCode());
            }
            jsonWriter.key("active");
            jsonWriter.value(contexte.isActive());
            ContexteList children = contexte.getChildren();
            int childCount = children.getContexteCount();
            if (childCount > 0) {
                jsonWriter.key("contexteArray");
                jsonWriter.array();
                for (int i = 0; i < childCount; ++i) {
                    this.writeContexte(jsonWriter, children.getContexte(i));
                }
                jsonWriter.endArray();
            }
        }
        jsonWriter.key("color");
        jsonWriter.value((Object)ColorUtils.toHexFormat((Color)AtlasAttributes.getColor(contexte)));
        jsonWriter.endObject();
    }

    private void writeCommon(JSONWriter jsonWriter, Term terme) throws IOException {
        jsonWriter.key("code");
        jsonWriter.value((long)terme.getCode());
        jsonWriter.key("type");
        jsonWriter.value((long)terme.getTermType());
        jsonWriter.key("libelleArray");
        jsonWriter.array();
        if (this.langArray != null) {
            for (Lang lang : this.langArray) {
                Label label = terme.getLabels().getLabel(lang);
                if (label == null) continue;
                jsonWriter.object();
                jsonWriter.key("lang");
                jsonWriter.value((Object)lang.toString());
                jsonWriter.key("lib");
                jsonWriter.value((Object)label.getLabelString());
                jsonWriter.endObject();
            }
        } else {
            for (Label label : terme.getLabels()) {
                jsonWriter.object();
                jsonWriter.key("lang");
                jsonWriter.value((Object)label.getLang().toString());
                jsonWriter.key("lib");
                jsonWriter.value((Object)label.getLabelString());
                jsonWriter.endObject();
            }
        }
        jsonWriter.endArray();
    }
}

