/*
 * Decompiled with CFR 0.152.
 */
package net.scrutari.dataexport.xml;

import java.util.ArrayList;
import java.util.List;
import net.scrutari.dataexport.api.RelationExport;
import net.scrutari.dataexport.xml.XmlAttributeExport;
import net.scrutari.dataexport.xml.XmlWriter;

public class XmlRelationExport
extends XmlAttributeExport
implements RelationExport {
    private static final String[] NAME_ARRAY = new String[]{"role", "type", "uri"};
    private final List<String> memberList = new ArrayList<String>();
    private String type;

    public void reinit(String type) {
        this.type = type;
        this.memberList.clear();
        super.clear();
    }

    @Override
    public void addMember(String role, String type, String uri) {
        this.memberList.add(role);
        this.memberList.add(type);
        this.memberList.add(uri);
    }

    @Override
    public void writeXML(XmlWriter xmlWriter) {
        String[] value = new String[3];
        xmlWriter.openTagWithAttribute("relation", "type", this.type);
        int length = this.memberList.size() / 3;
        for (int i = 0; i < length; ++i) {
            value[0] = this.memberList.get(i * 3);
            value[1] = this.memberList.get(i * 3 + 1);
            value[2] = this.memberList.get(i * 3 + 2);
            xmlWriter.addEmptyElement("member", NAME_ARRAY, value);
        }
        this.writeAttributes(xmlWriter);
        xmlWriter.closeTag("relation");
    }
}

