/*
 * Decompiled with CFR 0.152.
 */
package net.scrutari.dataexport.xml;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.scrutari.dataexport.api.CorpusMetadataExport;
import net.scrutari.dataexport.xml.XmlMetadataExport;
import net.scrutari.dataexport.xml.XmlWriter;

public class XmlCorpusMetadataExport
extends XmlMetadataExport
implements CorpusMetadataExport {
    private final Map<String, String> corpusMap = new LinkedHashMap<String, String>();
    private final Map<String, String> ficheMap = new LinkedHashMap<String, String>();
    private final List<Map<String, String>> complementMapList = new ArrayList<Map<String, String>>();
    private String corpusIcon;
    private String hrefParent;

    @Override
    public void setCorpusIcon(String corpusIcon) {
        this.corpusIcon = corpusIcon;
    }

    @Override
    public void setHrefParent(String hrefParent) {
        this.hrefParent = hrefParent;
    }

    @Override
    public void setIntitule(int intituleType, String lang, String intituleValue) {
        Map<String, String> map = this.getMap(intituleType);
        map.put(lang, intituleValue);
    }

    @Override
    public int addComplement() {
        this.complementMapList.add(new LinkedHashMap());
        return this.complementMapList.size();
    }

    @Override
    public void setComplementIntitule(int complementNumber, String lang, String intituleValue) {
        if (complementNumber < 0 || complementNumber > this.complementMapList.size()) {
            return;
        }
        Map<String, String> map = this.complementMapList.get(complementNumber - 1);
        map.put(lang, intituleValue);
    }

    @Override
    public void writeXML(XmlWriter xmlWriter) {
        xmlWriter.openTag("corpus-metadata");
        this.addMap(1, xmlWriter);
        this.addMap(2, xmlWriter);
        xmlWriter.addSimpleElement("href-parent", this.hrefParent);
        xmlWriter.addSimpleElement("corpus-icon", this.corpusIcon);
        for (Map<String, String> map : this.complementMapList) {
            this.addComplementMap(map, xmlWriter);
        }
        this.writePhrases(xmlWriter);
        this.writeAttributes(xmlWriter);
        xmlWriter.closeTag("corpus-metadata");
    }

    private void addComplementMap(Map<String, String> map, XmlWriter xmlWriter) {
        xmlWriter.openTag("complement-metadata");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            xmlWriter.addLibElement(entry.getKey(), entry.getValue());
        }
        xmlWriter.closeTag("complement-metadata");
    }

    private void addMap(int intituleType, XmlWriter xmlWriter) {
        Map<String, String> map = this.getMap(intituleType);
        if (map.isEmpty()) {
            return;
        }
        String suffix = XmlCorpusMetadataExport.getSuffix(intituleType);
        xmlWriter.openTag("intitule-" + suffix);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            xmlWriter.addLibElement(entry.getKey(), entry.getValue());
        }
        xmlWriter.closeTag("intitule-" + suffix);
    }

    private Map<String, String> getMap(int type) {
        switch (type) {
            case 1: {
                return this.corpusMap;
            }
            case 2: {
                return this.ficheMap;
            }
        }
        throw new IllegalArgumentException("Wrong intituleType = " + type);
    }

    private static String getSuffix(int type) {
        switch (type) {
            case 1: {
                return "corpus";
            }
            case 2: {
                return "fiche";
            }
        }
        throw new IllegalArgumentException("Wrong intituleType = " + type);
    }
}

