/*
 * Decompiled with CFR 0.152.
 */
package net.scrutari.dataexport.xml;

import java.util.LinkedHashMap;
import java.util.Map;
import net.scrutari.dataexport.api.AttributeExport;
import net.scrutari.dataexport.xml.AttributeBuffer;
import net.scrutari.dataexport.xml.XmlBuilder;
import net.scrutari.dataexport.xml.XmlWriter;

public abstract class XmlAttributeExport
extends XmlBuilder
implements AttributeExport {
    private final Map<String, AttributeBuffer> attributeMap = new LinkedHashMap<String, AttributeBuffer>();

    @Override
    public void addAttributeValue(String nameSpace, String localKey, String attributeValue) {
        if (nameSpace.length() == 0) {
            return;
        }
        if (localKey.length() == 0) {
            return;
        }
        if (attributeValue.length() == 0) {
            return;
        }
        String key = nameSpace + ":" + localKey;
        AttributeBuffer buffer = this.attributeMap.get(key);
        if (buffer == null) {
            buffer = new AttributeBuffer(nameSpace, localKey);
            this.attributeMap.put(key, buffer);
        }
        buffer.addValue(attributeValue);
    }

    protected void writeAttributes(XmlWriter xmlWriter) {
        for (AttributeBuffer buffer : this.attributeMap.values()) {
            buffer.writeXML(xmlWriter);
        }
    }

    protected void clear() {
        this.attributeMap.clear();
    }
}

