/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.text.tableparser;

import java.lang.reflect.InvocationTargetException;
import net.mapeadores.util.exceptions.NestedClassLoaderException;
import net.mapeadores.util.text.StringUtils;
import net.mapeadores.util.text.tableparser.CsvParameters;
import net.mapeadores.util.text.tableparser.CsvParser;
import net.mapeadores.util.text.tableparser.SheetCopyParameters;
import net.mapeadores.util.text.tableparser.SimpleCsvParser;

public final class TableParser {
    public static final String CSV_PARSETYPE = "csv";
    public static final String SHEETCOPY_PARSETYPE = "sheetcopy";
    private static CsvParser csvParser = null;

    private TableParser() {
    }

    public static String[][] parse(String s, Parameters parameters) {
        if (parameters instanceof SheetCopyParameters) {
            return TableParser.parseSheetCopy(s, (SheetCopyParameters)parameters);
        }
        if (parameters instanceof CsvParameters) {
            if (csvParser != null) {
                return csvParser.parse(s, (CsvParameters)parameters);
            }
            SimpleCsvParser scp = new SimpleCsvParser();
            return scp.parse(s, (CsvParameters)parameters);
        }
        throw new IllegalArgumentException("unknown TableParser.Parameters implementations = " + parameters.getClass().getName());
    }

    private static String[][] parseSheetCopy(String s, SheetCopyParameters parameters) {
        String[] lines = StringUtils.getLineTokens(s, (short)0);
        int length = lines.length;
        String[][] result = new String[length][];
        for (int i = 0; i < length; ++i) {
            String line = lines[i];
            String[] tokens = StringUtils.getTokens(line, '\t', (short)0);
            result[i] = tokens;
        }
        return result;
    }

    public static boolean isCsvParserInit() {
        return csvParser != null;
    }

    public static void initCsvParser(String className) {
        try {
            Class<?> csvParserClass = Class.forName(className);
            csvParser = (CsvParser)csvParserClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new NestedClassLoaderException(e);
        }
    }

    public static String checkParseType(String parseType) {
        switch (parseType) {
            case "csv": {
                return CSV_PARSETYPE;
            }
            case "sheetcopy": {
                return SHEETCOPY_PARSETYPE;
            }
        }
        throw new IllegalArgumentException("Unknown parse type: " + parseType);
    }

    public static interface Parameters {
    }
}

