/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.parsers.junction;

import java.text.ParseException;
import net.fichotheque.FichothequeQuestioner;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.junction.TieBuffer;
import net.fichotheque.tools.parsers.junction.TieToken;
import net.mapeadores.util.annotation.Nullable;

public class TieBufferParser {
    private TieBufferParser() {
    }

    public static TieBuffer parse(FichothequeQuestioner fichothequeQuestioner, String tokenString, short subsetCategory) throws ParseException {
        return TieBufferParser.parse(fichothequeQuestioner, tokenString, subsetCategory, null, null);
    }

    public static TieBuffer parse(FichothequeQuestioner fichothequeQuestioner, String tokenString, short subsetCategory, Subset defaultSubset, String mode) throws ParseException {
        TieToken tieToken = TieToken.parse(tokenString);
        int weight = tieToken.getWeight();
        if (mode == null) {
            mode = tieToken.getMode();
        }
        SubsetItem subsetItem = fichothequeQuestioner.parseGlobalId(tieToken.getText(), subsetCategory, defaultSubset);
        return new TieBuffer(subsetItem, mode, weight);
    }

    public static TieBuffer parseId(Subset subset, String tokenString, @Nullable String mode, int weightFilter) throws ParseException {
        int id;
        TieToken tieToken = TieToken.parse(tokenString);
        int weight = weightFilter < 1 ? tieToken.getWeight() : weightFilter;
        if (mode == null) {
            mode = tieToken.getMode();
        }
        try {
            id = Integer.parseInt(tieToken.getText());
        }
        catch (NumberFormatException nfe) {
            throw new ParseException(tokenString, 0);
        }
        if (id < 0) {
            throw new ParseException(tokenString, 0);
        }
        SubsetItem subsetItem = subset.getSubsetItemById(id);
        if (subsetItem == null) {
            throw new ParseException(tokenString, 0);
        }
        return new TieBuffer(subsetItem, mode, weight);
    }

    public static TieBuffer parseIdalpha(Thesaurus thesaurus, String tokenString, String mode, int weightFilter) throws ParseException {
        Motcle motcle;
        TieToken tieToken = TieToken.parse(tokenString);
        int weight = weightFilter < 1 ? tieToken.getWeight() : weightFilter;
        if (mode == null) {
            mode = tieToken.getMode();
        }
        if ((motcle = thesaurus.getMotcleByIdalpha(tieToken.getText())) == null) {
            throw new ParseException(tokenString, 0);
        }
        return new TieBuffer(motcle, mode, weight);
    }
}

