/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.importation.parsers.corpus;

import java.text.ParseException;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.tools.importation.ParseResultBuilder;
import net.fichotheque.tools.importation.corpus.EditCorpusImportBuilder;
import net.fichotheque.tools.importation.corpus.EditFicheImportBuilder;
import net.fichotheque.tools.importation.parsers.ImportationParseContext;
import net.fichotheque.tools.importation.parsers.Row;
import net.fichotheque.tools.importation.parsers.corpus.CorpusColumns;
import net.fichotheque.tools.importation.parsers.corpus.CorpusRowParser;
import net.fichotheque.tools.importation.parsers.handlers.HandlerUtils;
import net.fichotheque.tools.parsers.FicheParser;
import net.mapeadores.util.date.FuzzyDate;

abstract class EditRowParser
extends CorpusRowParser {
    final EditCorpusImportBuilder editCorpusImportBuilder;
    final ParseResultBuilder parseResultBuilder;
    final FicheParser ficheParser;
    final CorpusColumns corpusColumns;
    final ImportationParseContext parseContext;
    final Corpus corpus;

    EditRowParser(EditCorpusImportBuilder editCorpusImportBuilder, ParseResultBuilder parseResultBuilder, FicheParser ficheParser, CorpusColumns corpusColumns, ImportationParseContext parseContext) {
        this.editCorpusImportBuilder = editCorpusImportBuilder;
        this.parseResultBuilder = parseResultBuilder;
        this.ficheParser = ficheParser;
        this.corpusColumns = corpusColumns;
        this.parseContext = parseContext;
        this.corpus = editCorpusImportBuilder.getCorpus();
    }

    @Override
    public EditCorpusImportBuilder getCorpusImportBuilder() {
        return this.editCorpusImportBuilder;
    }

    void populate(EditFicheImportBuilder ficheImportBuilder, Row row) {
        if (this.corpusColumns.hasFicheHandler()) {
            HandlerUtils.populate(ficheImportBuilder.getFicheChangeBuilder(), this.corpusColumns.getFicheHandlerArray(), row, this.ficheParser);
        }
        if (this.corpusColumns.hasAttributeHandler()) {
            HandlerUtils.populate(ficheImportBuilder.getAttributeChangeBuilder(), this.corpusColumns.getAttributeHandlerArray(), row);
        }
        if (this.corpusColumns.hasJunctionHandler()) {
            HandlerUtils.populate(ficheImportBuilder.getTiesImportBuilder(), this.corpusColumns.getJunctionHandlers(), row, this.editCorpusImportBuilder.getCorpus(), this.parseContext);
        }
    }

    void setCreationDate(EditFicheImportBuilder ficheImportBuilder, int rowNumber, Row row) {
        int creationDateIndex = this.corpusColumns.getCreationDateIndex();
        if (creationDateIndex != -1 && row.getColumnCount() > creationDateIndex) {
            String creationDateString = row.getColumnValue(creationDateIndex).trim();
            try {
                FuzzyDate creationDate = FuzzyDate.parse(creationDateString);
                ficheImportBuilder.setCreationDate(creationDate);
            }
            catch (ParseException die) {
                this.parseResultBuilder.wrongDate(rowNumber, creationDateString);
            }
        }
    }
}

