/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.importation.parsers;

import java.text.ParseException;
import java.util.List;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.importation.TiesImport;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.policies.DynamicEditPolicy;
import net.fichotheque.thesaurus.policies.PolicyProvider;
import net.fichotheque.tools.importation.ImportationUtils;
import net.fichotheque.tools.importation.TiesImportBuilder;
import net.fichotheque.tools.importation.parsers.ImportationParseContext;
import net.fichotheque.tools.junction.TieBuffer;
import net.fichotheque.tools.parsers.junction.TieBufferParser;
import net.fichotheque.tools.parsers.junction.WeightMotcleToken;
import net.fichotheque.utils.ThesaurusUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.CleanedString;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.text.StringUtils;

public class TiesParser {
    public static final short DEFAULT_PARSE = 0;
    public static final short IDALPHA_PARSE = 1;
    public static final short ID_PARSE = 2;
    private final TiesImportBuilder tiesImportBuilder;
    private final Corpus defaultCorpus;
    private final boolean corpusStyle;
    private final Fichotheque fichotheque;
    private final ImportationParseContext parseContext;

    public TiesParser(Subset mainSubset, TiesImportBuilder tiesImportBuilder, ImportationParseContext parseContext) {
        this.tiesImportBuilder = tiesImportBuilder;
        this.fichotheque = mainSubset.getFichotheque();
        if (mainSubset instanceof Corpus) {
            this.defaultCorpus = (Corpus)mainSubset;
            this.corpusStyle = true;
        } else {
            this.defaultCorpus = null;
            this.corpusStyle = false;
        }
        this.parseContext = parseContext;
    }

    public void addRemovedIncludeKey(IncludeKey includeKey) {
        this.tiesImportBuilder.addRemovedIncludeKey(includeKey);
    }

    public void add(IncludeKey includeKey, List<String> values, boolean replace, short thesaurusParseType) {
        SubsetKey subsetKey = includeKey.getSubsetKey();
        Subset otherSubset = this.fichotheque.getSubset(subsetKey);
        if (otherSubset == null) {
            return;
        }
        if (subsetKey.isThesaurusSubset()) {
            Thesaurus thesaurus = (Thesaurus)otherSubset;
            this.add(thesaurus, includeKey, values, replace, thesaurusParseType);
        } else {
            this.parseIds(otherSubset, includeKey, values, replace);
        }
    }

    private void add(Thesaurus thesaurus, IncludeKey includeKey, List<String> values, boolean replace, short thesaurusParseType) {
        if (thesaurusParseType == 1) {
            if (thesaurus.isIdalphaType()) {
                for (String value : values) {
                    this.parseIdalpha(thesaurus, includeKey, value, replace);
                }
            } else {
                for (String value : values) {
                    this.parseId(thesaurus, includeKey, value, replace, true);
                }
            }
        } else if (thesaurusParseType == 0 && this.corpusStyle) {
            Lang thesaurusLang = ThesaurusUtils.checkDisponibility(this.parseContext.getThesaurusLangChecker(), thesaurus, this.parseContext.getWorkingLang());
            DynamicEditPolicy dynamicEditPolicy = this.getDynamicEditPolicy(thesaurus);
            for (String value : values) {
                this.parseMotcle(thesaurus, includeKey, value, thesaurusLang, dynamicEditPolicy, replace);
            }
        } else {
            this.parseIds(thesaurus, includeKey, values, replace);
        }
    }

    public void addLiage(List<String> values, boolean replace) {
        for (String value : values) {
            this.parseLiage(value, replace);
        }
    }

    private void parseLiage(String value, boolean replace) {
        String[] tokens;
        for (String token : tokens = StringUtils.getTechnicalTokens(value, false)) {
            try {
                TieBuffer tieBuffer = TieBufferParser.parse(this.parseContext.getFichothequeQuestioner(), token, (short)1, this.defaultCorpus, "");
                SubsetItem otherSubsetItem = tieBuffer.getSubsetItem();
                Subset otherSubset = otherSubsetItem.getSubset();
                IncludeKey.newInstance(otherSubset.getSubsetKey());
                TiesImport.TieImport tieImport = this.toTieImport(IncludeKey.newInstance(otherSubset.getSubsetKey()), otherSubsetItem, tieBuffer.getWeight());
                if (replace) {
                    this.tiesImportBuilder.addReplaceTieImport(tieImport);
                    continue;
                }
                this.tiesImportBuilder.addAppendTieImport(tieImport);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    private void parseIds(Subset otherSubset, IncludeKey includeKey, List<String> values, boolean replace) {
        for (String value : values) {
            this.parseId(otherSubset, includeKey, value, replace, false);
        }
    }

    private void parseId(Subset otherSubset, IncludeKey includeKey, String value, boolean replace, boolean checkUndescore) {
        String[] tokens;
        int weightFilter = includeKey.getWeightFilter();
        String mode = includeKey.getMode();
        for (String token : tokens = StringUtils.getTechnicalTokens(value, false)) {
            if (checkUndescore && token.startsWith("_")) {
                token = token.substring(1);
            }
            try {
                TieBuffer tieBuffer = TieBufferParser.parseId(otherSubset, token, mode, weightFilter);
                TiesImport.TieImport tieImport = this.toTieImport(includeKey, tieBuffer);
                if (replace) {
                    this.tiesImportBuilder.addReplaceTieImport(tieImport);
                    continue;
                }
                this.tiesImportBuilder.addAppendTieImport(tieImport);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    private void parseIdalpha(Thesaurus thesaurus, IncludeKey includeKey, String value, boolean replace) {
        String[] tokens;
        int weightFilter = includeKey.getWeightFilter();
        String mode = includeKey.getMode();
        for (String token : tokens = StringUtils.getTechnicalTokens(value, false)) {
            try {
                TieBuffer tieBuffer = TieBufferParser.parseIdalpha(thesaurus, token, mode, weightFilter);
                TiesImport.TieImport tieImport = this.toTieImport(includeKey, tieBuffer);
                if (replace) {
                    this.tiesImportBuilder.addReplaceTieImport(tieImport);
                    continue;
                }
                this.tiesImportBuilder.addAppendTieImport(tieImport);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    private void parseMotcle(Thesaurus thesaurus, IncludeKey includeKey, String value, Lang thesaurusLang, DynamicEditPolicy dynamicEditPolicy, boolean replace) {
        String[] tokens;
        boolean withIdalpha = thesaurus.isIdalphaType();
        int weightFilter = includeKey.getWeightFilter();
        String mode = includeKey.getMode();
        block12: for (String token : tokens = StringUtils.getTechnicalTokens(value, ';', false)) {
            WeightMotcleToken motcleToken = WeightMotcleToken.parse(token, withIdalpha, weightFilter);
            if (motcleToken == null) continue;
            int weight = motcleToken.getWeight();
            Motcle motcle = WeightMotcleToken.getMotcle(motcleToken, thesaurus, thesaurusLang);
            if (motcle != null) {
                TiesImport.TieImport tieImport = this.toTieImport(includeKey, motcle, weight);
                if (replace) {
                    this.tiesImportBuilder.addReplaceTieImport(tieImport);
                    continue;
                }
                this.tiesImportBuilder.addAppendTieImport(tieImport);
                continue;
            }
            CleanedString labelText = motcleToken.getText();
            switch (dynamicEditPolicy.getType()) {
                case "allow": {
                    if (motcleToken.isIdBundle()) continue block12;
                    Label label = this.toLabel(thesaurusLang, labelText);
                    TiesImport.TieImport tieImport = ImportationUtils.toTieImport(includeKey, thesaurus, label, weight);
                    if (replace) {
                        this.tiesImportBuilder.addReplaceTieImport(tieImport);
                        continue block12;
                    }
                    this.tiesImportBuilder.addAppendTieImport(tieImport);
                    continue block12;
                }
                case "transfer": {
                    if (motcleToken.isIdBundle()) continue block12;
                    Thesaurus transferThesaurus = ThesaurusUtils.getTransferThesaurus(this.fichotheque, dynamicEditPolicy);
                    Motcle transferMotcle = this.getMotcle(transferThesaurus, thesaurusLang, labelText);
                    IncludeKey includeKey2 = IncludeKey.newInstance(transferThesaurus.getSubsetKey(), mode, weightFilter);
                    if (transferMotcle == null) {
                        Label label = this.toLabel(thesaurusLang, labelText);
                        this.tiesImportBuilder.addAppendTieImport(ImportationUtils.toTieImport(includeKey2, transferThesaurus, label, weight));
                        continue block12;
                    }
                    this.tiesImportBuilder.addAppendTieImport(this.toTieImport(includeKey2, transferMotcle, weight));
                    continue block12;
                }
                case "check": {
                    if (motcleToken.isIdBundle()) continue block12;
                    Thesaurus[] checkThesaurusArray = ThesaurusUtils.getCheckThesaurusArray(this.fichotheque, dynamicEditPolicy);
                    boolean done = false;
                    for (Thesaurus checkThesaurus : checkThesaurusArray) {
                        Motcle checkMotcle = this.getMotcle(checkThesaurus, thesaurusLang, labelText);
                        if (checkMotcle == null) continue;
                        IncludeKey checkIncludeKey = IncludeKey.newInstance(checkThesaurus.getSubsetKey(), mode, weightFilter);
                        this.tiesImportBuilder.addAppendTieImport(this.toTieImport(checkIncludeKey, checkMotcle, weight));
                        done = true;
                        break;
                    }
                    if (done) continue block12;
                    Label label = this.toLabel(thesaurusLang, labelText);
                    TiesImport.TieImport tieImport = ImportationUtils.toTieImport(includeKey, thesaurus, label, weight);
                    if (replace) {
                        this.tiesImportBuilder.addReplaceTieImport(tieImport);
                        continue block12;
                    }
                    this.tiesImportBuilder.addAppendTieImport(tieImport);
                    continue block12;
                }
                case "external": {
                    TiesImport.TieImport tieImport = null;
                    if (withIdalpha) {
                        tieImport = motcleToken.isIdBundle() ? ImportationUtils.toTieImport(includeKey, thesaurus, String.valueOf(motcleToken.getId()), weight) : ImportationUtils.toTieImport(includeKey, thesaurus, labelText.toString(), weight);
                    } else if (motcleToken.isIdBundle()) {
                        tieImport = ImportationUtils.toTieImport(includeKey, (Subset)thesaurus, motcleToken.getId(), weight);
                    } else {
                        Label label = this.toLabel(thesaurusLang, labelText);
                        tieImport = ImportationUtils.toTieImport(includeKey, thesaurus, label, weight);
                    }
                    if (tieImport == null) continue block12;
                    if (replace) {
                        this.tiesImportBuilder.addReplaceTieImport(tieImport);
                        continue block12;
                    }
                    this.tiesImportBuilder.addAppendTieImport(tieImport);
                }
            }
        }
    }

    private Label toLabel(Lang thesaurusLang, CleanedString labelString) {
        if (labelString != null) {
            return LabelUtils.toLabel(thesaurusLang, labelString);
        }
        return null;
    }

    private Motcle getMotcle(Thesaurus thesaurus, Lang thesaurusLang, CleanedString labelString) {
        if (labelString == null) {
            return null;
        }
        Lang lang = ThesaurusUtils.checkDisponibility(this.parseContext.getThesaurusLangChecker(), thesaurus, thesaurusLang);
        return thesaurus.seekMotcleByLabel(labelString.toString(), lang);
    }

    private DynamicEditPolicy getDynamicEditPolicy(Thesaurus thesaurus) {
        DynamicEditPolicy dynamicEditPolicy = ThesaurusUtils.NONE_POLICY;
        PolicyProvider policyProvider = this.parseContext.getPolicyProvider();
        if (policyProvider != null) {
            dynamicEditPolicy = policyProvider.getDynamicEditPolicy(thesaurus);
        }
        return dynamicEditPolicy;
    }

    private TiesImport.TieImport toTieImport(IncludeKey includeKey, TieBuffer tieBuffer) {
        SubsetItem subsetItem = tieBuffer.getSubsetItem();
        return ImportationUtils.toTieImport(includeKey, subsetItem.getSubset(), subsetItem.getId(), tieBuffer.getWeight());
    }

    private TiesImport.TieImport toTieImport(IncludeKey includeKey, SubsetItem subsetItem, int weight) {
        return ImportationUtils.toTieImport(includeKey, subsetItem.getSubset(), subsetItem.getId(), weight);
    }
}

