/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.parsers;

import net.fichotheque.addenda.Document;
import net.fichotheque.format.FormatContext;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.formatters.DocumentFormatter;
import net.fichotheque.tools.format.JsonParameters;
import net.fichotheque.tools.format.LangParameters;
import net.fichotheque.tools.format.catalogs.DocumentFormatterCatalog;
import net.fichotheque.utils.FormatterUtils;
import net.mapeadores.util.instruction.Argument;
import net.mapeadores.util.instruction.Instruction;
import net.mapeadores.util.instruction.InstructionResolver;
import net.mapeadores.util.instruction.InstructionResolverProvider;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.logging.MessageHandler;

public final class DocumentFormatterParser {
    private static final JsonParameters DEFAULT_JSONPARAMETERS = JsonParameters.build("type", "id", "basename", "versions");

    private DocumentFormatterParser() {
    }

    public static DocumentFormatter parse(String pattern, FormatContext formatContext, boolean withWeightFilter, MessageHandler messageHandler) {
        if (pattern == null) {
            pattern = "{basename}{extensions}";
        }
        try {
            return DocumentFormatterParser.parse(pattern, formatContext, withWeightFilter);
        }
        catch (ErrorMessageException fe) {
            messageHandler.addMessage("severe.format.pattern", fe.getErrorMessage());
            return null;
        }
    }

    public static DocumentFormatter parse(String pattern, FormatContext formatContext, boolean withWeightFilter) throws ErrorMessageException {
        Object[] partArray = FormatterUtils.parsePattern(new InternalInstructionResolver(formatContext, withWeightFilter), pattern);
        return new InternalDocumentFormatter(partArray);
    }

    private static class InternalInstructionResolver
    implements InstructionResolver {
        private final InstructionResolverProvider provider;
        private final boolean withWeightFilter;

        private InternalInstructionResolver(FormatContext formatContext, boolean withWeightFilter) {
            this.provider = formatContext.getInstructionResolverProvider();
            this.withWeightFilter = withWeightFilter;
        }

        @Override
        public Object resolve(Instruction instruction) throws ErrorMessageException {
            String key;
            Object formatter;
            InstructionResolver resolver = this.provider.getInstructionResolver(DocumentFormatter.class);
            if (resolver != null && (formatter = resolver.resolve(instruction)) != null) {
                return formatter;
            }
            Argument arg1 = (Argument)instruction.get(0);
            switch (key = arg1.getKey()) {
                case "addenda": {
                    return DocumentFormatterCatalog.ADDENDA;
                }
                case "basename": {
                    return DocumentFormatterCatalog.BASENAME;
                }
                case "extensions": {
                    return DocumentFormatterCatalog.EXTENSIONS;
                }
                case "formsyntax": {
                    if (this.withWeightFilter) {
                        return DocumentFormatterCatalog.WITHWEIGHTFILTER_FORMSYNTAX;
                    }
                    return DocumentFormatterCatalog.WITHOUTWEIGHTFILTER_FORMSYNTAX;
                }
                case "id": {
                    return DocumentFormatterCatalog.ID;
                }
                case "json": {
                    JsonParameters jsonParameters = JsonParameters.fromInstruction(instruction, DEFAULT_JSONPARAMETERS);
                    LangParameters langParameters = LangParameters.fromInstruction(instruction, "langs");
                    return new DocumentFormatterCatalog.Json(jsonParameters, langParameters.getCustomLangContext());
                }
                case "weight": 
                case "poids": {
                    return DocumentFormatterCatalog.WEIGHT;
                }
            }
            return null;
        }
    }

    private static class InternalDocumentFormatter
    implements DocumentFormatter {
        private final Object[] partArray;

        private InternalDocumentFormatter(Object[] partArray) {
            this.partArray = partArray;
        }

        @Override
        public String formatDocument(Document document, int weight, FormatSource formatSource) {
            StringBuilder buf = new StringBuilder();
            for (Object obj : this.partArray) {
                if (obj instanceof String) {
                    buf.append((String)obj);
                    continue;
                }
                DocumentFormatter formatter = (DocumentFormatter)obj;
                buf.append(formatter.formatDocument(document, weight, formatSource));
            }
            return buf.toString();
        }
    }
}

