/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.table;

import java.io.IOException;
import java.io.Writer;
import net.mapeadores.util.date.FuzzyDate;
import net.mapeadores.util.exceptions.NestedIOException;
import net.mapeadores.util.money.Amount;
import net.mapeadores.util.primitives.Decimal;
import net.mapeadores.util.sql.InsertWriter;
import net.mapeadores.util.table.TableWriter;

public class SqlTableWriter
implements TableWriter {
    protected InsertWriter insertWriter;
    protected Writer writer;
    protected String tableName;
    private boolean notNull;
    private int rowNumber;
    private int columnNumber;

    public SqlTableWriter(Writer writer, String tableName) {
        this.insertWriter = new InsertWriter(writer);
        this.tableName = tableName;
        this.writer = writer;
        this.rowNumber = 0;
    }

    public void setNotNull(boolean notNull) {
        this.notNull = notNull;
    }

    @Override
    public int startRow() {
        ++this.rowNumber;
        try {
            this.insertWriter.startInsert(this.tableName);
        }
        catch (IOException ioe) {
            throw new NestedIOException(ioe);
        }
        this.columnNumber = 0;
        return this.rowNumber;
    }

    @Override
    public int addIntegerCell(Long lg) {
        ++this.columnNumber;
        try {
            if (lg == null) {
                if (this.notNull) {
                    this.insertWriter.addInteger(0L);
                } else {
                    this.insertWriter.addNull();
                }
            } else {
                this.insertWriter.addInteger(lg);
            }
        }
        catch (IOException ioe) {
            throw new NestedIOException(ioe);
        }
        return this.columnNumber;
    }

    @Override
    public int addDecimalCell(Decimal decimal) {
        ++this.columnNumber;
        try {
            if (decimal == null) {
                if (this.notNull) {
                    this.insertWriter.addDecimal(new Decimal(0L, 0, 0));
                } else {
                    this.insertWriter.addNull();
                }
            } else {
                this.insertWriter.addDecimal(decimal);
            }
        }
        catch (IOException ioe) {
            throw new NestedIOException(ioe);
        }
        return this.columnNumber;
    }

    @Override
    public int addStringCell(String s) {
        ++this.columnNumber;
        try {
            if (s == null) {
                if (this.notNull) {
                    this.insertWriter.addText("");
                } else {
                    this.insertWriter.addNull();
                }
            } else {
                this.insertWriter.addText(s);
            }
        }
        catch (IOException ioe) {
            throw new NestedIOException(ioe);
        }
        return this.columnNumber;
    }

    @Override
    public int addDateCell(FuzzyDate date) {
        ++this.columnNumber;
        try {
            if (date == null) {
                if (this.notNull) {
                    date = FuzzyDate.current();
                } else {
                    this.insertWriter.addNull();
                    return this.columnNumber;
                }
            }
            this.insertWriter.addText(date.toISOString());
        }
        catch (IOException ioe) {
            throw new NestedIOException(ioe);
        }
        return this.columnNumber;
    }

    @Override
    public int addMoneyCell(Amount amount) {
        ++this.columnNumber;
        try {
            if (amount == null) {
                if (this.notNull) {
                    this.insertWriter.addText("");
                } else {
                    this.insertWriter.addNull();
                }
            } else {
                this.insertWriter.addText(amount.toString());
            }
        }
        catch (IOException ioe) {
            throw new NestedIOException(ioe);
        }
        return this.columnNumber;
    }

    @Override
    public int addPercentageCell(Decimal decimal) {
        return this.addDecimalCell(decimal);
    }

    @Override
    public int endRow() {
        try {
            this.insertWriter.endInsertLine();
        }
        catch (IOException ioe) {
            throw new NestedIOException(ioe);
        }
        return this.rowNumber;
    }
}

