/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.sql.dom;

import java.text.ParseException;
import java.util.function.Consumer;
import net.fichotheque.Fichotheque;
import net.fichotheque.tools.exportation.sql.SqlExportDefBuilder;
import net.fichotheque.tools.selection.SelectionDOMUtils;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.text.RelativePath;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.DomMessages;
import org.w3c.dom.Element;

public class SqlExportDefDOMReader {
    private final Fichotheque fichotheque;
    private final SqlExportDefBuilder sqlExportDefBuilder;
    private final MessageHandler messageHandler;

    public SqlExportDefDOMReader(Fichotheque fichotheque, SqlExportDefBuilder sqlExportDefBuilder, MessageHandler messageHandler) {
        this.fichotheque = fichotheque;
        this.sqlExportDefBuilder = sqlExportDefBuilder;
        this.messageHandler = messageHandler;
    }

    public SqlExportDefDOMReader read(Element element) {
        DOMUtils.readChildren(element, new RootConsumer());
        return this;
    }

    public static SqlExportDefDOMReader init(Fichotheque fichotheque, SqlExportDefBuilder sqlExportDefBuilder, MessageHandler messageHandler) {
        return new SqlExportDefDOMReader(fichotheque, sqlExportDefBuilder, messageHandler);
    }

    private class RootConsumer
    implements Consumer<Element> {
        private RootConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "param": {
                    String name = element.getAttribute("name").trim();
                    if (name.length() == 0) {
                        DomMessages.emptyAttribute(SqlExportDefDOMReader.this.messageHandler, "param", "name");
                        return;
                    }
                    String value = element.getAttribute("value").trim();
                    if (value.isEmpty()) {
                        value = DOMUtils.readSimpleElement(element);
                    }
                    SqlExportDefDOMReader.this.sqlExportDefBuilder.addParam(name, value);
                    break;
                }
                case "sqlexport-classname": {
                    SqlExportDefDOMReader.this.sqlExportDefBuilder.setSqlExportClassName(DOMUtils.readSimpleElement(element));
                    break;
                }
                case "tableexport-name": {
                    SqlExportDefDOMReader.this.sqlExportDefBuilder.setTableExportName(DOMUtils.readSimpleElement(element));
                    break;
                }
                case "post-command": {
                    SqlExportDefDOMReader.this.sqlExportDefBuilder.setPostCommand(DOMUtils.readSimpleElement(element));
                    break;
                }
                case "target-name": {
                    SqlExportDefDOMReader.this.sqlExportDefBuilder.setTargetName(DOMUtils.readSimpleElement(element));
                    break;
                }
                case "target-path": {
                    String targetPath = DOMUtils.readSimpleElement(element);
                    try {
                        RelativePath relativePath = RelativePath.parse(targetPath);
                        SqlExportDefDOMReader.this.sqlExportDefBuilder.setTargetPath(relativePath);
                    }
                    catch (ParseException pe) {
                        DomMessages.wrongElementValue(SqlExportDefDOMReader.this.messageHandler, tagName, targetPath);
                    }
                    break;
                }
                case "file-name": {
                    String fileName = DOMUtils.readSimpleElement(element);
                    try {
                        SqlExportDefDOMReader.this.sqlExportDefBuilder.setFileName(fileName);
                    }
                    catch (ParseException pe) {
                        DomMessages.wrongElementValue(SqlExportDefDOMReader.this.messageHandler, tagName, fileName);
                    }
                    break;
                }
                case "label": 
                case "lib": {
                    try {
                        LabelUtils.readLabel(element, SqlExportDefDOMReader.this.sqlExportDefBuilder);
                    }
                    catch (ParseException ile) {
                        DomMessages.wrongLangAttribute(SqlExportDefDOMReader.this.messageHandler, tagName, element.getAttribute("xml:lang"));
                    }
                    break;
                }
                case "attr": {
                    AttributeUtils.readAttrElement(SqlExportDefDOMReader.this.sqlExportDefBuilder.getAttributesBuilder(), element);
                    break;
                }
                case "path": {
                    this.readOldPathElement(DOMUtils.readSimpleElement(element));
                    break;
                }
                case "url": {
                    break;
                }
                default: {
                    if (SelectionDOMUtils.readSelectionOptions(SqlExportDefDOMReader.this.sqlExportDefBuilder.getSelectionOptionsBuilder(), SqlExportDefDOMReader.this.fichotheque, element)) break;
                    DomMessages.unknownTagWarning(SqlExportDefDOMReader.this.messageHandler, tagName);
                }
            }
        }

        private void readOldPathElement(String path) {
            int idx = path.lastIndexOf("/");
            if (idx > 0) {
                try {
                    SqlExportDefDOMReader.this.sqlExportDefBuilder.setFileName(path.substring(idx + 1));
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                path = path.substring(0, idx + 1);
                this.testOldTarget(path, "/home/tomcat/www/", "www");
                this.testOldTarget(path, "/home/tomcat/sync/", "sync");
            }
        }

        private void testOldTarget(String path, String suffix, String targetName) {
            if (path.startsWith(suffix)) {
                SqlExportDefDOMReader.this.sqlExportDefBuilder.setTargetName(targetName);
                try {
                    RelativePath relativePath = RelativePath.parse(path.substring(suffix.length()));
                    SqlExportDefDOMReader.this.sqlExportDefBuilder.setTargetPath(relativePath);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
    }
}

