/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.dom;

import java.text.ParseException;
import java.util.function.Consumer;
import net.fichotheque.ExistingIdException;
import net.fichotheque.FichothequeConstants;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.SphereEditor;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.DomMessages;
import org.w3c.dom.Element;

public class SphereListDOMReader {
    private final Handler handler;
    private final MessageHandler messageHandler;

    public SphereListDOMReader(SphereEditor sphereEditor, MessageHandler messageHandler) {
        this.handler = new SphereEditorHandler(sphereEditor);
        this.messageHandler = messageHandler;
    }

    public SphereListDOMReader(Handler handler, MessageHandler messageHandler) {
        this.handler = handler;
        this.messageHandler = messageHandler;
    }

    public void fillSphere(Element element) {
        DOMUtils.readChildren(element, new RootConsumer());
    }

    public static abstract class Handler {
        public abstract void checkRedacteur(int var1, String var2, String var3) throws ExistingIdException, ParseException;
    }

    private static class SphereEditorHandler
    extends Handler {
        private final SphereEditor sphereEditor;

        private SphereEditorHandler(SphereEditor sphereEditor) {
            this.sphereEditor = sphereEditor;
        }

        @Override
        public void checkRedacteur(int id, String login, String status) throws ExistingIdException, ParseException {
            Redacteur redacteur = this.sphereEditor.createRedacteur(id, login);
            this.sphereEditor.setStatus(redacteur, status);
        }
    }

    private class RootConsumer
    implements Consumer<Element> {
        private RootConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("redacteur")) {
                int id;
                String idString = element.getAttribute("id");
                if (idString.length() == 0) {
                    idString = element.getAttribute("idsph");
                }
                if (idString.length() == 0) {
                    DomMessages.emptyAttribute(SphereListDOMReader.this.messageHandler, tagName, "id");
                    return;
                }
                try {
                    id = Integer.parseInt(idString);
                }
                catch (NumberFormatException nfe) {
                    DomMessages.wrongIntegerAttributeValue(SphereListDOMReader.this.messageHandler, tagName, "id", idString);
                    return;
                }
                String login = element.getAttribute("login");
                if (login.length() == 0) {
                    DomMessages.emptyAttribute(SphereListDOMReader.this.messageHandler, tagName, "login");
                    return;
                }
                try {
                    SphereListDOMReader.this.handler.checkRedacteur(id, login, this.getStatus(element));
                }
                catch (ExistingIdException eie) {
                    SphereListDOMReader.this.messageHandler.addMessage("severe.fichotheque", "_ error.existing.id", login);
                }
                catch (ParseException pe) {
                    DomMessages.wrongAttributeValue(SphereListDOMReader.this.messageHandler, tagName, "login", login);
                }
            } else {
                DomMessages.unknownTagWarning(SphereListDOMReader.this.messageHandler, tagName);
            }
        }

        private String getStatus(Element element) {
            String status = "active";
            String statusAttr = element.getAttribute("status");
            if (statusAttr.isEmpty()) {
                String activeString = element.getAttribute("active");
                if (activeString.isEmpty()) {
                    activeString = element.getAttribute("actif");
                }
                if (activeString.equals("0")) {
                    status = "inactive";
                }
            } else {
                try {
                    status = FichothequeConstants.checkRedacteurStatus(statusAttr);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return status;
        }
    }
}

