/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.conversion.fieldtofield;

import java.util.ArrayList;
import net.fichotheque.corpus.fiche.Fiche;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.ParaItem;
import net.fichotheque.corpus.fiche.Section;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.tools.conversion.ConversionUtils;
import net.fichotheque.tools.conversion.fieldtofield.FieldToFieldConverter;
import net.mapeadores.util.logging.MultiMessageHandler;

class SectionToFicheItemField
extends FieldToFieldConverter {
    private final FieldKey sourceKey;
    private final FieldKey destinationKey;

    SectionToFicheItemField(FieldKey sourceKey, FieldKey destinationKey, MultiMessageHandler messageHandler) {
        super(messageHandler);
        this.sourceKey = sourceKey;
        this.destinationKey = destinationKey;
    }

    @Override
    void convertContent(Fiche fiche, boolean removeOldField) {
        int size;
        Section ficheBlocks = fiche.getSection(this.sourceKey);
        if (ficheBlocks == null || ficheBlocks.isEmpty()) {
            return;
        }
        ArrayList<ParaItem> paraItemList = new ArrayList<ParaItem>();
        boolean onlyP = ConversionUtils.appendPara(paraItemList, ficheBlocks);
        if (!onlyP) {
            this.addWarning("_ warning.conversion.containsnotonlyp", this.sourceKey.getKeyString());
        }
        if ((size = paraItemList.size()) == 0) {
            return;
        }
        if (this.destinationKey.isProp()) {
            FicheItem ficheItem = (FicheItem)paraItemList.get(0);
            fiche.setProp(this.destinationKey, ficheItem);
            if (size > 1) {
                this.addWarning("_ warning.conversion.manyficheblocks", this.sourceKey.getKeyString());
            }
        } else {
            fiche.appendInfo(this.destinationKey, ConversionUtils.toFicheItems(paraItemList));
        }
        if (removeOldField) {
            fiche.setSection(this.sourceKey, null);
        }
    }
}

