/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.impl;

import java.text.ParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.fichotheque.EditOrigin;
import net.fichotheque.ExistingIdException;
import net.fichotheque.Fichotheque;
import net.fichotheque.FichothequeConstants;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.Metadata;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.impl.AbstractSubsetItem;
import net.fichotheque.impl.FichothequeImpl;
import net.fichotheque.impl.Listeners;
import net.fichotheque.impl.SphereDataSource;
import net.fichotheque.impl.SphereMetadataImpl;
import net.fichotheque.sphere.LoginKey;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.Sphere;
import net.fichotheque.sphere.SphereEditor;
import net.fichotheque.sphere.metadata.SphereMetadataEditor;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.utils.SphereUtils;
import net.mapeadores.util.models.EmailCore;
import net.mapeadores.util.models.PersonCore;
import net.mapeadores.util.models.PersonCoreUtils;
import net.mapeadores.util.text.collation.map.SortedCollatedKeyMap;

class SphereImpl
implements Sphere {
    private final SubsetKey sphereKey;
    private final FichothequeImpl fichotheque;
    private final SortedCollatedKeyMap<Redacteur> loginMap;
    private final Map<Integer, RedacteurImpl> itemMap = new HashMap<Integer, RedacteurImpl>();
    private int availableId = 1;
    private SphereMetadataImpl sphereMetadata;
    private List<SubsetItem> cacheSubsetItemList;
    private List<Redacteur> cacheList;

    private SphereImpl(SubsetKey sphereKey, FichothequeImpl fichotheque) {
        this.sphereKey = sphereKey;
        this.fichotheque = fichotheque;
        this.loginMap = new SortedCollatedKeyMap(Locale.ENGLISH);
    }

    static InitEditor fromInit(SubsetKey sphereKey, FichothequeImpl fichotheque, FichothequeImpl.InitEditor fichothequeInitEditor) {
        SphereImpl sphere = new SphereImpl(sphereKey, fichotheque);
        return new InitEditor(sphere, fichothequeInitEditor);
    }

    static SphereImpl fromNew(SubsetKey sphereKey, FichothequeImpl fichotheque) {
        SphereImpl sphere = new SphereImpl(sphereKey, fichotheque);
        sphere.sphereMetadata = SphereMetadataImpl.fromNew(sphere);
        return sphere;
    }

    @Override
    public SubsetKey getSubsetKey() {
        return this.sphereKey;
    }

    @Override
    public SubsetItem getSubsetItemById(int id) {
        return this.itemMap.get(id);
    }

    @Override
    public int size() {
        return this.itemMap.size();
    }

    @Override
    public List<SubsetItem> getSubsetItemList() {
        List<SubsetItem> list = this.cacheSubsetItemList;
        if (list == null) {
            list = this.initSubsetItemList();
        }
        return list;
    }

    @Override
    public Fichotheque getFichotheque() {
        return this.fichotheque;
    }

    @Override
    public Metadata getMetadata() {
        return this.sphereMetadata;
    }

    @Override
    public List<Redacteur> getRedacteurList() {
        List<Redacteur> result = this.cacheList;
        if (result == null) {
            result = this.initRedacteurList();
        }
        return result;
    }

    @Override
    public Redacteur getRedacteurById(int id) {
        return this.itemMap.get(id);
    }

    @Override
    public Redacteur getRedacteurByLogin(String login) {
        return this.loginMap.getValue(login);
    }

    @Override
    public List<Corpus> getSatelliteCorpusList() {
        return FichothequeUtils.EMPTY_CORPUSLIST;
    }

    SphereEditorImpl getSphereEditor(FichothequeEditor fichothequeEditor) {
        return new SphereEditorImpl(fichothequeEditor);
    }

    Listeners getListeners() {
        return this.fichotheque.getListeners();
    }

    private synchronized Redacteur innerCreateRedacteur(int id, String login) throws ExistingIdException, ParseException {
        if (id < 1) {
            id = this.availableId;
        } else if (this.itemMap.containsKey(id)) {
            throw new ExistingIdException();
        }
        if (this.loginMap.getValue(login) != null) {
            throw new ExistingIdException();
        }
        LoginKey.checkLogin(login);
        RedacteurImpl defredac = new RedacteurImpl(id, login);
        this.itemMap.put(id, defredac);
        this.loginMap.putValue(login, defredac);
        this.availableId = Math.max(this.availableId, id + 1);
        this.clearCache();
        return defredac;
    }

    private synchronized boolean innerRemoveRedacteur(Redacteur redacteur) {
        if (!this.fichotheque.isRemoveable(redacteur)) {
            return false;
        }
        RedacteurImpl redacteurImpl = this.testRedacteur(redacteur);
        int id = redacteurImpl.getId();
        String login = redacteurImpl.getLogin();
        this.itemMap.remove(id);
        this.loginMap.removeValue(login);
        this.clearCache();
        return true;
    }

    private synchronized boolean innerSetLogin(Redacteur redacteur, String newLogin) throws ExistingIdException, ParseException {
        LoginKey.checkLogin(newLogin);
        if (this.loginMap.getValue(newLogin) != null) {
            throw new ExistingIdException();
        }
        RedacteurImpl defredac = this.testRedacteur(redacteur);
        String currentLogin = defredac.getLogin();
        boolean done = defredac.setLogin(newLogin);
        if (done) {
            this.loginMap.removeValue(currentLogin);
            this.loginMap.putValue(newLogin, defredac);
        }
        return done;
    }

    private boolean innerSetEmail(Redacteur redacteur, EmailCore email) {
        RedacteurImpl defredac = this.testRedacteur(redacteur);
        return defredac.setEmail(email);
    }

    private boolean innerSetPerson(Redacteur redacteur, PersonCore person) {
        RedacteurImpl defredac = this.testRedacteur(redacteur);
        return defredac.setPerson(person);
    }

    private boolean innerSetStatus(Redacteur redacteur, String status) {
        RedacteurImpl defredac = this.testRedacteur(redacteur);
        return defredac.setStatus(status);
    }

    private void clearCache() {
        this.cacheSubsetItemList = null;
        this.cacheList = null;
    }

    private synchronized List<SubsetItem> initSubsetItemList() {
        TreeMap<Integer, RedacteurImpl> sortedMap = new TreeMap<Integer, RedacteurImpl>();
        sortedMap.putAll(this.itemMap);
        List<SubsetItem> list = FichothequeUtils.wrap(sortedMap.values().toArray(new Redacteur[sortedMap.size()]));
        this.cacheSubsetItemList = list;
        return list;
    }

    private synchronized List<Redacteur> initRedacteurList() {
        TreeMap<Integer, RedacteurImpl> sortedMap = new TreeMap<Integer, RedacteurImpl>();
        sortedMap.putAll(this.itemMap);
        List<Redacteur> list = SphereUtils.wrap(sortedMap.values().toArray(new Redacteur[sortedMap.size()]));
        this.cacheList = list;
        return list;
    }

    private RedacteurImpl testRedacteur(Redacteur redacteur) {
        if (redacteur == null) {
            throw new IllegalArgumentException("redacteur argument cannot be null");
        }
        try {
            RedacteurImpl defredacteur = (RedacteurImpl)redacteur;
            if (defredacteur.getSphere() != this) {
                throw new IllegalArgumentException("redacteur argument does not come from this sphere");
            }
            return defredacteur;
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("redacteur argument does not come from this sphere");
        }
    }

    static class InitEditor
    implements SphereEditor {
        private final SphereImpl sphere;
        private final FichothequeImpl.InitEditor fichothequeInitEditor;
        private final SphereMetadataImpl.InitEditor metadataInitEditor;

        private InitEditor(SphereImpl sphere, FichothequeImpl.InitEditor fichothequeInitEditor) {
            this.sphere = sphere;
            this.fichothequeInitEditor = fichothequeInitEditor;
            this.metadataInitEditor = SphereMetadataImpl.fromInit(this);
            sphere.sphereMetadata = (SphereMetadataImpl)this.metadataInitEditor.getMetadata();
        }

        @Override
        public Sphere getSphere() {
            return this.sphere;
        }

        @Override
        public FichothequeEditor getFichothequeEditor() {
            return this.fichothequeInitEditor;
        }

        @Override
        public SphereMetadataEditor getSphereMetadataEditor() {
            return this.metadataInitEditor;
        }

        @Override
        public Redacteur createRedacteur(int id, String login) throws ExistingIdException, ParseException {
            return this.sphere.innerCreateRedacteur(id, login);
        }

        @Override
        public boolean removeRedacteur(Redacteur redacteur) {
            throw new UnsupportedOperationException("Not during init");
        }

        @Override
        public boolean setLogin(Redacteur redacteur, String newLogin) throws ExistingIdException, ParseException {
            throw new UnsupportedOperationException("Not during init");
        }

        @Override
        public boolean setEmail(Redacteur redacteur, EmailCore email) {
            return this.sphere.innerSetEmail(redacteur, email);
        }

        @Override
        public boolean setPerson(Redacteur redacteur, PersonCore person) {
            return this.sphere.innerSetPerson(redacteur, person);
        }

        @Override
        public boolean setStatus(Redacteur redacteur, String status) {
            return this.sphere.innerSetStatus(redacteur, status);
        }
    }

    class SphereEditorImpl
    implements SphereEditor {
        private final FichothequeEditor fichothequeEditor;
        private final Set<Integer> changedRedacteurSet = new HashSet<Integer>();
        private final Set<Integer> removedRedacteurSet = new HashSet<Integer>();
        private SphereMetadataEditor sphereMetadataEditor;
        private boolean listChanged = false;
        private boolean metadataChanged = false;

        private SphereEditorImpl(FichothequeEditor fichothequeEditor) {
            this.fichothequeEditor = fichothequeEditor;
        }

        @Override
        public Sphere getSphere() {
            return SphereImpl.this;
        }

        @Override
        public FichothequeEditor getFichothequeEditor() {
            return this.fichothequeEditor;
        }

        @Override
        public SphereMetadataEditor getSphereMetadataEditor() {
            if (this.sphereMetadataEditor == null) {
                this.sphereMetadataEditor = SphereImpl.this.sphereMetadata.getSphereMetadataEditor(this);
            }
            return this.sphereMetadataEditor;
        }

        @Override
        public Redacteur createRedacteur(int id, String login) throws ExistingIdException, ParseException {
            Redacteur redacteur = SphereImpl.this.innerCreateRedacteur(id, login);
            this.setListChange();
            return redacteur;
        }

        @Override
        public boolean removeRedacteur(Redacteur redacteur) {
            int id = redacteur.getId();
            boolean done = SphereImpl.this.innerRemoveRedacteur(redacteur);
            if (done) {
                this.setListChange();
                this.removedRedacteurSet.add(id);
                SphereImpl.this.getListeners().fireSubsetItemRemoved(this.fichothequeEditor, SphereImpl.this, id);
            }
            return done;
        }

        @Override
        public boolean setLogin(Redacteur redacteur, String newLogin) throws ExistingIdException, ParseException {
            boolean done = SphereImpl.this.innerSetLogin(redacteur, newLogin);
            if (done) {
                this.setListChange();
            }
            return done;
        }

        @Override
        public boolean setEmail(Redacteur redacteur, EmailCore emailCore) {
            boolean done = SphereImpl.this.innerSetEmail(redacteur, emailCore);
            if (done) {
                this.addRedacteurChange(redacteur.getId());
            }
            return done;
        }

        @Override
        public boolean setPerson(Redacteur redacteur, PersonCore personCore) {
            boolean done = SphereImpl.this.innerSetPerson(redacteur, personCore);
            if (done) {
                this.addRedacteurChange(redacteur.getId());
            }
            return done;
        }

        @Override
        public boolean setStatus(Redacteur redacteur, String status) {
            boolean done = SphereImpl.this.innerSetStatus(redacteur, status);
            if (done) {
                this.setListChange();
            }
            return done;
        }

        void addRedacteurChange(int id) {
            this.changedRedacteurSet.add(id);
        }

        void setListChange() {
            this.listChanged = true;
        }

        void setMetadataChange() {
            this.metadataChanged = true;
        }

        void saveChanges() {
            EditOrigin editOrigin = this.fichothequeEditor.getEditOrigin();
            SphereDataSource sphereDataSource = SphereImpl.this.fichotheque.getFichothequeDataSource().getSphereDataSource();
            for (Integer id : this.changedRedacteurSet) {
                Redacteur redacteur = SphereImpl.this.getRedacteurById(id);
                if (redacteur == null) continue;
                sphereDataSource.saveRedacteur(redacteur, editOrigin);
            }
            this.changedRedacteurSet.clear();
            for (Integer id : this.removedRedacteurSet) {
                sphereDataSource.removeRedacteur(SphereImpl.this, id, editOrigin);
            }
            this.removedRedacteurSet.clear();
            if (this.listChanged) {
                sphereDataSource.saveList(SphereImpl.this, editOrigin);
                this.listChanged = false;
            }
            if (this.metadataChanged) {
                sphereDataSource.saveMetadata(SphereImpl.this, editOrigin);
                this.metadataChanged = false;
            }
        }
    }

    private class RedacteurImpl
    extends AbstractSubsetItem
    implements Redacteur {
        private final String globalId;
        private final int id;
        private String login;
        private PersonCore person = PersonCoreUtils.EMPTY_PERSONCORE;
        private InternalEmail email = null;
        private String status = "active";

        private RedacteurImpl(int id, String login) {
            this.id = id;
            this.globalId = FichothequeUtils.toGlobalId(SphereImpl.this.getSubsetKey(), id);
            this.login = login;
        }

        @Override
        public String getGlobalId() {
            return this.globalId;
        }

        @Override
        public Subset getSubset() {
            return SphereImpl.this;
        }

        @Override
        public String getLogin() {
            return this.login;
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public String getStatus() {
            return this.status;
        }

        private boolean setLogin(String newLogin) {
            if (newLogin.equals(this.login)) {
                return false;
            }
            this.login = newLogin;
            return true;
        }

        private boolean setStatus(String newStatus) {
            if (newStatus.equals(this.status)) {
                return false;
            }
            this.status = FichothequeConstants.checkRedacteurStatus(newStatus);
            return true;
        }

        private boolean setPerson(PersonCore newPerson) {
            if (newPerson == null) {
                throw new IllegalArgumentException("newPersonCore argument is null");
            }
            if (!PersonCoreUtils.areEqual(newPerson, this.person)) {
                this.person = PersonCoreUtils.clonePersonCore(newPerson);
                return true;
            }
            return false;
        }

        private boolean setEmail(EmailCore newEmail) {
            if (newEmail == null) {
                if (this.email != null) {
                    this.email = null;
                    return true;
                }
                return false;
            }
            String realName = newEmail.getRealName();
            if (realName.equals(this.person.toStandardStyle())) {
                realName = "";
            }
            InternalEmail newInternalEmail = new InternalEmail(newEmail.getAddrSpec(), realName);
            if (this.email == null) {
                this.email = newInternalEmail;
                return true;
            }
            if (this.email.equals(newInternalEmail)) {
                return false;
            }
            this.email = newInternalEmail;
            return true;
        }

        @Override
        public EmailCore getEmailCore() {
            return this.email;
        }

        @Override
        public PersonCore getPersonCore() {
            return this.person;
        }

        private class InternalEmail
        implements EmailCore {
            private final String addrSpec;
            private final String realName;

            private InternalEmail(String addrSpec, String realName) {
                this.addrSpec = addrSpec;
                this.realName = realName;
            }

            @Override
            public String getAddrSpec() {
                return this.addrSpec;
            }

            @Override
            public String getRealName() {
                return this.realName;
            }

            @Override
            public String getComputedRealName() {
                if (this.realName.isEmpty()) {
                    return RedacteurImpl.this.person.toStandardStyle();
                }
                return this.realName;
            }

            public int hashCode() {
                return this.addrSpec.hashCode() + this.realName.hashCode();
            }

            public boolean equals(Object other) {
                if (other == null) {
                    return false;
                }
                if (other == this) {
                    return true;
                }
                if (other.getClass() != this.getClass()) {
                    return false;
                }
                InternalEmail otherEmail = (InternalEmail)other;
                return otherEmail.addrSpec.equals(this.addrSpec) && otherEmail.realName.equals(this.realName);
            }
        }
    }
}

