/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque;

import java.text.ParseException;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.addenda.Version;
import net.fichotheque.corpus.fiche.PersonItem;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.UserLoginException;
import net.fichotheque.thesaurus.Motcle;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.models.PersonCore;
import net.mapeadores.util.models.PersonCoreUtils;

public interface FichothequeQuestioner {
    public SubsetItem parseGlobalId(String var1, short var2, @Nullable Subset var3) throws ParseException;

    public Motcle parseGlobalIdalpha(String var1) throws ParseException;

    public Version parseVersionKey(String var1) throws ParseException;

    default public Redacteur getRedacteurByGlobalId(String userGlobalId) {
        try {
            return (Redacteur)this.parseGlobalId(userGlobalId, (short)3, null);
        }
        catch (ParseException pe) {
            return null;
        }
    }

    public Redacteur getRedacteurByLogin(String var1, @Nullable SubsetKey var2) throws UserLoginException;

    default public Redacteur getRedacteurByLogin(String login) throws UserLoginException {
        return this.getRedacteurByLogin(login, null);
    }

    default public String getUserGlobalId(String login, @Nullable SubsetKey defaultSphereKey) throws UserLoginException {
        Redacteur redacteur = this.getRedacteurByLogin(login, defaultSphereKey);
        return redacteur.getGlobalId();
    }

    default public String getUserGlobalId(String login) throws UserLoginException {
        return this.getUserGlobalId(login, null);
    }

    default public PersonCore toPersonCore(PersonItem personne) {
        String userGlobalId = personne.getRedacteurGlobalId();
        if (userGlobalId != null) {
            Redacteur redacteur = this.getRedacteurByGlobalId(userGlobalId);
            if (redacteur != null) {
                return redacteur.getPersonCore();
            }
            return PersonCoreUtils.toPersonCore(userGlobalId, "", "", false);
        }
        return personne.getPersonCore();
    }
}

