/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.memento;

import fr.exemole.bdfserver.api.memento.MementoNode;
import fr.exemole.bdfserver.tools.memento.MementoUtils;
import java.util.ArrayList;
import java.util.List;

public class MementoNodeBuilder {
    private final String name;
    private final List<MementoNode> subnodeList = new ArrayList<MementoNode>();
    private String title = "";
    private String text = "";

    public MementoNodeBuilder(String name) {
        this.name = name;
    }

    public MementoNodeBuilder setTitle(String title) {
        this.title = title == null ? "" : title;
        return this;
    }

    public MementoNodeBuilder setText(String text) {
        this.text = text == null ? "" : text.trim();
        return this;
    }

    public MementoNodeBuilder addSubnode(MementoNode subnode) {
        this.subnodeList.add(subnode);
        return this;
    }

    public MementoNode toMementoNode() {
        if (this.title.isEmpty()) {
            this.title = this.name;
        }
        List<MementoNode> finalList = this.subnodeList.isEmpty() ? MementoUtils.EMPTY_NODELIST : MementoUtils.wrap(this.subnodeList.toArray(new MementoNode[this.subnodeList.size()]));
        return new InternalMementoNode(this.name, this.title, finalList, this.text);
    }

    private static class InternalMementoNode
    implements MementoNode {
        private final String name;
        private final String title;
        private final List<MementoNode> mementoNodeList;
        private final String text;

        private InternalMementoNode(String name, String title, List<MementoNode> mementoNodeList, String text) {
            this.name = name;
            this.title = title;
            this.mementoNodeList = mementoNodeList;
            this.text = text;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        @Override
        public boolean isLeaf() {
            return this.mementoNodeList.isEmpty();
        }

        @Override
        public List<MementoNode> getSubnodeList() {
            return this.mementoNodeList;
        }

        @Override
        public String getText() {
            return this.text;
        }
    }
}

